package data;

/**
 * Presents a role in the security context of the application.
 * A role has a type e.g. ADMIN, MODERATOR, EDITOR ... and assigned rights
 * which are represented as boolean variables.
 * 
 * @author Ferdinand Kaiser
 *
 */
public class Role {
	
	private RoleEnum type;
	
	private boolean createArticle;
	private boolean updateArticle;
	private boolean deleteArticle;
	
	private boolean createComment;
	private boolean updateComment;
	private boolean deleteComment;
	
	private boolean createEvent;
	private boolean updateEvent;
	private boolean deleteEvent;
	
	private boolean createImage;
	private boolean updateImage;
	private boolean deleteImage;
	
	private boolean createLocation;
	private boolean updateLocation;
	private boolean deleteLocation;

	private boolean createUser;
	private boolean updateUser;
	private boolean deleteUser;

	private boolean createTag;
	private boolean updateTag;
	private boolean deleteTag;

	private boolean createForumThread;
	private boolean updateForumThread;
	private boolean deleteForumThread;
	

}
