package data;

import java.util.HashSet;
import java.util.Set;

/**
 * A tag is a short, one-word description of the content of an entry.
 * The tag as a name and two Hashsets, articles and events, that show
 * what articles/events this tag is assigned to.
 * @author Ferdinand Kaiser
 *
 */
public class Tag {

	private int id;
	private String name;

	private Set<Article> articles=new HashSet();
	private Set<Event> events=new HashSet();	
	
	public Tag(){
		
	}
	
	/**
	 * 
	 * @param name name of the event
	 */
	public Tag(String name) {
		super();
		this.name = name;
	}	
	
	/**
	 * 
	 * @return unique id
	 */
	public int getId() {
		return id;
	}

	/**
	 * sets the unique id, only to be used by Hibernate!
	 * @param id
	 */
	private void setId(int id) {
		this.id = id;
	}

	/**
	 * 
	 * @return name of the tag
	 */
	public String getName() {
		return name;
	}

	/**
	 * sets name of the tag
	 * @param name
	 */
	public void setName(String name) {
		this.name = name;
	}		
	
	/**
	 * 
	 * @return list of the articles, this tag is assigned to
	 */
	public Set<Article> getArticles() {
		return articles;
	}

	/**
	 * sets the set of articles, only to be used by Hibernate!
	 * @param articles
	 */
	public void setArticles(Set<Article> articles) {
		this.articles = articles;
	}

	/**
	 * 
	 * @return list of the events, this tag is assigned to
	 */
	public Set<Event> getEvents() {
		return events;
	}

	/**
	 * sets the set of events, only to be used by Hibernate!
	 * @param articles
	 */
	public void setEvents(Set<Event> events) {
		this.events = events;
	}

}
