package helpers;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

/**
 * Static methods for date and time operations
 * 
 * @author Roland Krner
 * 
 */
public class DateHelper {

	/**
	 * Takes the time of a date and adds it to another date.
	 * 
	 * @param date
	 *            The date the time will be added to
	 * @param time
	 *            The time to be added
	 * @return the added values
	 */
	public static Date addTimeToDate(Date date, Date time) {
		int hour, minute;

		GregorianCalendar cal = new GregorianCalendar();
		cal.setTime(time);
		hour = cal.get(Calendar.HOUR_OF_DAY);
		minute = cal.get(Calendar.MINUTE);

		cal.setTime(date);

		cal.add(Calendar.HOUR_OF_DAY, hour);
		cal.add(Calendar.MINUTE, minute);

		return cal.getTime();
	}

	/**
	 * Gets the time from a date.
	 * 
	 * @param date
	 *            The date that the time will be taken from
	 * @return time in "HH:mm" format
	 */
	public static String getTime(Date date) {
		int hour, minute;
		GregorianCalendar cal = new GregorianCalendar();
		cal.setTime(date);
		hour = cal.get(Calendar.HOUR_OF_DAY);
		minute = cal.get(Calendar.MINUTE);

		return (hour + ":" + minute);

	}

}
