package manager;


import repository.*;


/**
 * Holds the different DAOclasses, that are represented as Singleton.
 * @author Ferdinand Kaiser, 05.04.08
 *
 */
public class DAOManager {


    private static ArticleDAO articleDAO;
    private static ImageDAO imageDAO;
    private static LocationDAO locationDAO;
    private static UserDAO userDAO;
    private static CommentDAO commentDAO;
    private static EventDAO eventDAO;
    private static ForumThreadDAO forumthreadDAO;
    private static TagDAO tagDAO;
    private static FileDAO fileDAO;
	
	static {
        articleDAO=new ArticleDAO();
        imageDAO=new ImageDAO();
        locationDAO=new LocationDAO();
        userDAO=new UserDAO();
        commentDAO=new CommentDAO();
        forumthreadDAO=new ForumThreadDAO();
        eventDAO=new EventDAO();
        tagDAO=new TagDAO();
        fileDAO=new FileDAO("images/",25);
    }	
	
	public static void init(){
        articleDAO=new ArticleDAO();
        imageDAO=new ImageDAO();
        locationDAO=new LocationDAO();
        userDAO=new UserDAO();
        commentDAO=new CommentDAO();
        forumthreadDAO=new ForumThreadDAO();
        eventDAO=new EventDAO();
        tagDAO=new TagDAO();
	}
	
    public static ArticleDAO getArticleDAO() {
        return articleDAO;
    }
    
    public static ImageDAO getImageDAO() {
        return imageDAO;
    }
    
    public static LocationDAO getLocationDAO() {
        return locationDAO;
    }

    public static UserDAO getUserDAO() {
        return userDAO;
    }

    public static CommentDAO getCommentDAO(){
    	return commentDAO;
    }
    
    public static EventDAO getEventDAO(){
    	return eventDAO;
    }

    public static TagDAO getTagDAO(){
    	return tagDAO;
    }
    
    public static FileDAO getFileDAO(){
    	return fileDAO;
    }
    
    public static ForumThreadDAO getForumThreadDAO(){
    	return forumthreadDAO;
    }  
    
}

