package repository;

import java.util.Date;
import java.util.GregorianCalendar;

/**
 * A thin wrapper around GregorianCalendar
 * 
 * 
 * @author Ferdinand Kaiser
 *
 */
public class DateUtil {

	
	/**
	 * Constructs a GregorianCalendar instance
	 * @param y year
	 * @param m month starts from 1
	 * @param d day
	 * @param hh hour
	 * @param mm minute
	 * @return
	 */
	public static GregorianCalendar get(int d, int m, int y, int hh, int mm){
		return new GregorianCalendar(y,m-1,d,hh,mm);
	}
	
	
	/**
	 * Constructs a GregorianCalendar instance
	 * 
	 * @param y year 
	 * @param m month starts from 1
	 * @param d day
	 * @return actual Date as GregorianCalendar type
	 */
	public static GregorianCalendar get(int d, int m, int y){
		return new GregorianCalendar(y,m-1,d);
	}	
	
	/**
	 * Constructs a Gregoriancalendar instance
	 * @return actual Date as GregorianCalendar type
	 */
	public static GregorianCalendar get(){
		return new GregorianCalendar();
	}	
	
	
}
