package test;

import data.*;

public class MappingTestView {
	public static void displayArticle(Article article){
		System.out.println();
		System.out.println("Title:\t "+article.getTitle());
		System.out.println("Owner:\t "+article.getOwner().getFirstName()+" "+article.getOwner().getLastName()+" "
				+article.getOwner().getRole());
		System.out.println("Created: "+article.getCreationDate()+" Last Edit "+article.getLastEdit());
		System.out.println("Image:\t "+article.getImage().getFileName());
		System.out.println("Text:\t "+article.getText());
		System.out.println("Comments: ");
		try{
			for(Comment comment:article.getComments()){
				System.out.println("\t\tTitel:"+comment.getTitle()+"\n\t\t"+"Text: "+comment.getText());
				System.out.println("\t\t-------------------");
			}
			System.out.print("Tags: ");
			for(Tag tag:article.getTags()){
				System.out.print(tag.getName()+" ");
			}
			System.out.println();
		}
		catch(NullPointerException ex){
			System.out.println("No Comments/Tags.");
		}
		System.out.println();		
	}
	
	public static void displayForumThread(ForumThread thread){
		System.out.println();
		System.out.println("Title:\t "+thread.getTitle());
		System.out.println("Owner:\t "+thread.getOwner().getFirstName());
		System.out.println("Text:\t "+thread.getText());
		System.out.println("Comments: ");
		try{
			for(Comment comment:thread.getComments()){
				System.out.println("\t\tTitel:"+comment.getTitle()+"\n\t\t"+"Text: "+comment.getText());
				System.out.println("\t\t-------------------");
			}
			System.out.println();
		}
		catch(NullPointerException ex){
			System.out.println("No Comments/Tags.");
		}
		System.out.println();		
	}
	
	public static void displayEvent(Event event){
		System.out.println();
		System.out.println("Title:\t "+event.getTitle());
		System.out.println("Owner:\t "+event.getOwner().getFirstName()+" "+event.getOwner().getLastName());
		System.out.println("Start: "+event.getStartDate());
		System.out.println("Image:\t "+event.getImage().getFileName());
		System.out.println("Location: "+event.getLocation().getName());		
		System.out.println("Text:\t "+event.getText());
		System.out.println("Comments: ");
		try{
			for(Comment comment:event.getComments()){
				System.out.println("\t\tTitel:"+comment.getTitle()+"\n\t\t"+"Text: "+comment.getText());
				System.out.println("\t\t-------------------");
			}
			System.out.print("Tags: ");
			for(Tag tag:event.getTags()){
				System.out.print(tag.getName()+" ");
			}
			System.out.println();
		
		}
		catch(NullPointerException ex){
			System.out.println("No Comments/Tags.");
		}
		System.out.println();		
	}	
}
