package mks.cmd;

import hudson.util.ArgumentListBuilder;
import mks.config.JobSettings;
import mks.config.MksAuthTypeListBoxModel;


/**
 * Abstract MKS command
 * @author James Sheets
 */
public abstract class AbstractMksCmd
extends AbstractCmd
{
    protected String sandboxDesscriptor = "project.pj";

    public AbstractMksCmd(final String command, final JobSettings jobSettings)
    {
        add( desc.getExecutable() );
        add( command );
        
        // Create a specific connection
        if ( jobSettings.getAuthType().equalsIgnoreCase( MksAuthTypeListBoxModel.SPECIFIC_USER ) )
        {
//            if ( StringUtils.isBlank(jobSettings.getServer()) )
//                throw new IllegalArgumentException("MKS server host name is empty");
//            if ( StringUtils.isBlank(jobSettings.getPort().toString()) )
//                throw new IllegalArgumentException("MKS server port is empty");
//            if ( StringUtils.isBlank(jobSettings.getUsername()) )
//                throw new IllegalArgumentException("MKS user name is empty");
//            if ( StringUtils.isBlank(jobSettings.getPassword()) )
//                throw new IllegalArgumentException("MKS user password is empty");
            
            addKeyValuePair( "--hostname", jobSettings.getServer() );
            addKeyValuePair( "--port", jobSettings.getPort().toString() );
            addKeyValuePair( "--user", jobSettings.getUsername() );
            addKeyValuePair( "--password", jobSettings.getPassword(), true );
        }
    }
    
    
    public final ArgumentListBuilder addKeyValuePair(String key, String value)
    {
        return addKeyValuePair(key, value, false);
    }


    public final ArgumentListBuilder addKeyValuePair(String key, String value, final boolean mask)
    {
        if (value == null)
            throw new IllegalArgumentException(String.format("The field '%s' is not set", key));

        return super.addKeyValuePair("", key, value, mask);
    }
    
}
