package mks.cmd;

import mks.config.JobSettings;
import org.apache.commons.lang.StringUtils;

/**
 * Check in a member change (must be checked out)
 * 
 * @author James Sheets
 */
public class MksCmdCi 
extends AbstractMksCmd
{
    public MksCmdCi(final JobSettings jobSettings, final String sandboxDir, final String member
            , final String issueId, final String description)
    {
        super( "ci", jobSettings );
        
        addKeyValuePair( "--cwd", sandboxDir );
        addKeyValuePair( "--sandbox", sandboxDesscriptor );
        addKeyValuePair( "--onNewerRevision", "cancel" );
        addKeyValuePair( "--description", description );
        if (StringUtils.isNotBlank(issueId))
        {
            if (issueId.indexOf(":") > 0)
                addKeyValuePair( "--cpid", issueId );
            else if (StringUtils.isNotBlank(issueId))
                addKeyValuePair( "--issueId", issueId );
        }
        add( "--checkinUnchanged" );
        add( "--batch" );
        add( member );
    }


    @Override
    public String getDescription()
    {
        return "Check in a member";
    }


    @Override
    public int getTimeout()
    {
        return -1;
    }
}
