package mks.cmd;

import mks.config.JobSettings;
import org.apache.commons.lang.StringUtils;

/**
 * Check out a member
 * 
 * @author James Sheets
 */
public class MksCmdCo 
extends AbstractMksCmd
{
    public MksCmdCo(final JobSettings jobSettings, final String sandboxDir, final String member
            , final String issueId, final String description)
    {
        super( "co", jobSettings );
        
        addKeyValuePair( "--cwd", sandboxDir );
        addKeyValuePair( "--sandbox", sandboxDesscriptor );
        if (StringUtils.isNotBlank(issueId))
        {
            if (issueId.indexOf(":") > 0)
                addKeyValuePair( "--cpid", issueId );
            else if (StringUtils.isNotBlank(issueId))
                addKeyValuePair( "--issueId", issueId );
        }
        addKeyValuePair( "--mergeType", "automatic" );
        add( "--merge" );
        add( "--autolock" );
        add( "--nooverwriteChanged" );
        add( member );
    }


    @Override
    public String getDescription()
    {
        return "Check out a member";
    }


    @Override
    public int getTimeout()
    {
        return -1;
    }
}
