package mks.cmd;

import mks.config.JobSettings;
import mks.config.MksBuildTypeListBoxModel;
import mks.config.Project;

/**
 * Create a local sandbox for a project
 * 
 * @author James Sheets
 */
public class MksCmdCreateSandbox
extends AbstractMksCmd
{

    public MksCmdCreateSandbox(final JobSettings jobSettings
            , final int jobNumber, final String sandbox)
    {
        super( "createsandbox", jobSettings );

        final Project proj = jobSettings.getProjects().get( jobNumber );
        
        addKeyValuePair( "--project", proj.getConfigPath() );
        addKeyValuePair( "--cwd", sandbox );
        add( "--yes" );
        add( "--recurse" );
       
        if ( proj.getBuildType().equalsIgnoreCase(MksBuildTypeListBoxModel.PROJECT_REVISION) )
        {
            addKeyValuePair( "--projectrevision", proj.getProjectRevision() );
        }
    }


    @Override
    public String getDescription()
    {
        return "Create sandbox";
    }


    @Override
    public int getTimeout()
    {
        return desc.getTimeoutSettings().getCreateSandbox();
    }

}
