package mks.cmd;

import mks.config.JobSettings;
import org.apache.commons.lang.StringUtils;

/**
 * Drop a member
 * 
 * @author James Sheets
 */
public class MksCmdDrop 
extends AbstractMksCmd
{
    public MksCmdDrop(final JobSettings jobSettings, final String sandboxDir, final String member
            , final String issueId, final String description)
    {
        super( "drop", jobSettings );
        
        addKeyValuePair( "--cwd", sandboxDir );
        addKeyValuePair( "--sandbox", sandboxDesscriptor );
        addKeyValuePair( "--description", description);
        if (StringUtils.isNotBlank(issueId))
        {
            if (issueId.indexOf(":") > 0)
                addKeyValuePair( "--cpid", issueId );
            else if (StringUtils.isNotBlank(issueId))
                addKeyValuePair( "--issueId", issueId );
        }
        add( "--batch" );
        add( "--yes" );
        add( member );
    }


    @Override
    public String getDescription()
    {
        return "Drop member";
    }


    @Override
    public int getTimeout()
    {
        return -1;
    }
}
