package mks.cmd;

import mks.config.JobSettings;

/**
 * Drop a sandbox
 * @author James Sheets
 */
public class MksCmdDropSandbox
extends AbstractMksCmd
{

    public MksCmdDropSandbox(final JobSettings jobSettings
            , final String sandboxDir )
    {
        super( "dropsandbox", jobSettings);
        
        addKeyValuePair( "--cwd", sandboxDir );
        addKeyValuePair( "--delete", "members" );
        add( "--noconfirm" );
        add( sandboxDesscriptor );
    }


    @Override
    public String getDescription()
    {
        return "Drop sandbox";
    }


    @Override
    public int getTimeout()
    {
        return desc.getTimeoutSettings().getDrop();
    }

}
