package mks.cmd;

import mks.config.JobSettings;
import mks.config.Project;

/**
 * Freeze a project so no commits may occur
 * @author James Sheets
 */
public class MksCmdFreeze
extends AbstractMksCmd
{

    public MksCmdFreeze(final JobSettings jobSettings
            , final int jobNumber)
    {
        super( "freeze", jobSettings );

        final Project proj = jobSettings.getProjects().get( jobNumber );
        
        addKeyValuePair( "--project", proj.getConfigPath() );
        add( "--recurse" );
    }


    @Override
    public String getDescription()
    {
        return "Freeze project";
    }


    @Override
    public int getTimeout()
    {
        return desc.getTimeoutSettings().getFreeze();
    }

}
