package mks.cmd;

import mks.config.JobSettings;
import org.apache.commons.lang.StringUtils;

/**
 * Lock a member
 * 
 * @author SheeJam
 */
public class MksCmdLock 
extends AbstractMksCmd
{
    public MksCmdLock(final JobSettings jobSettings, final String sandboxDir, final String member
            , final String issueId, final String description)
    {
        super( "lock", jobSettings );
        
        addKeyValuePair( "--cwd", sandboxDir );
        addKeyValuePair( "--sandbox", sandboxDesscriptor );
        addKeyValuePair( "--locktype", "auto" );
        if (StringUtils.isNotBlank(issueId))
        {
            if (issueId.indexOf(":") > 0)
                addKeyValuePair( "--cpid", issueId );
            else if (StringUtils.isNotBlank(issueId))
                addKeyValuePair( "--issueId", issueId );
        }
        add( "--batch" );
        add( member );
    }


    @Override
    public String getDescription()
    {
        return "Lock a member";
    }


    @Override
    public int getTimeout()
    {
        return -1;
    }
}
