package mks.cmd;

import mks.config.JobSettings;
import mks.config.Project;

/**
 * Get information about the project
 * @author James Sheets
 */
public class MksCmdProjectInfo
extends AbstractMksCmd
{

    public MksCmdProjectInfo(final JobSettings jobSettings
            , final int jobNumber)
    {
        super( "projectinfo", jobSettings );

        final Project proj = jobSettings.getProjects().get( jobNumber );
        
        addKeyValuePair( "--project", proj.getConfigPath() );
        add( "--nodevpaths" );
        add( "--noattributes" );
        add( "--noassociatedIssues" );
        add( "--noacl" );
    }


    @Override
    public String getDescription()
    {
        return "Project info";
    }


    @Override
    public int getTimeout()
    {
        return desc.getTimeoutSettings().getInfo();
    }

}
