package mks.cmd;

import mks.config.JobSettings;

/**
 * Resyncronize a sandbox; get the latest version of the source code
 * @author James Sheets
 */
public class MksCmdRsync
extends AbstractMksCmd
{

    public MksCmdRsync(final JobSettings jobSettings
            , final String sandboxDir)
    {
        super( "resync", jobSettings );

        addKeyValuePair( "--cwd", sandboxDir);
        addKeyValuePair( "--sandbox", sandboxDesscriptor );
        add( "--recurse" );
        add( "--overwriteChanged" );
        add( "--overwriteIfPending" );
    }


    @Override
    public String getDescription()
    {
        return "Sandbox resync";
    }


    @Override
    public int getTimeout()
    {
        return desc.getTimeoutSettings().getResync();
    }

}
