package mks.cmd;

import mks.config.JobSettings;

/**
 * Test a sandbox to ensure it's valid
 * @author James Sheets
 */
public class MksCmdTestSandbox
extends AbstractMksCmd
{

    public MksCmdTestSandbox( final JobSettings jobSettings, final String sandboxDir )
    {
        super("projectinfo", jobSettings);
        
        addKeyValuePair( "--cwd", sandboxDir );
        addKeyValuePair( "--sandbox", sandboxDesscriptor );
        add( "--nodevpaths" );
        add( "--noattributes" );
        add( "--noassociatedIssues" );
        add( "--noacl" );
    }


    @Override
    public String getDescription()
    {
        return "Test sandbox integrity";
    }


    @Override
    public int getTimeout()
    {
        return desc.getTimeoutSettings().getTest();
    }

}