package mks.config;

/**
 * How long each command should run for before timing out and aborting the build
 * @author James Sheets
 */
public class TimeoutSettings
{
    public int TEST                 = 5*60;     // 5 min
    public int INFO                 = 5*60;     // 5 min
    public int DROP                 = 20*60;    // 20 min
    public int FREEZE               = 40*60;    // 40 min
    public int THAW                 = 40*60;    // 40 min
    public int CREATE_SANDBOX       = 40*60;    // 40 min
    public int RESYNC               = 40*60;    // 40 min
    public int RLOG                 = 40*60;    // 40 min
    public int CHECKPOINT           = 40*60;    // 40 min
    private static int WRITEABLE    = 0;        // no timeout

    // Get methods are primarily for access from global.jelly

    public int getTest()
    {
        return TEST;
    }
    
    public int getInfo()
    {
        return INFO;
    }

    public int getDrop()
    {
        return DROP;
    }

    public int getFreeze()
    {
        return FREEZE;
    }

    public int getThaw()
    {
        return THAW;
    }

    public int getCreateSandbox()
    {
        return CREATE_SANDBOX;
    }

    public int getResync()
    {
        return RESYNC;
    }

    public int getRlog()
    {
        return RLOG;
    }

    public int getCheckpoint()
    {
        return CHECKPOINT;
    }

    public int getWriteable()
    {
        return WRITEABLE;
    }
}
