package hudson.plugins.si;

import hudson.util.ArgumentListBuilder;

import java.io.File;

/* Generates an MKS Source Integrity Checkpoint Command.
 *
 * WARNING: Although the checkpoint will occur within a transaction on the source integrity database it
 * will include the latest revision of the source at the time of checkpoint -- this <b>MAY NOT</b> be
 * the revision used for the build (if a new revision was commited between the start of the build and
 * the initiation of the checkpoint). To prevent this from occurring use the freeze/thaw options.
 *
 * @author Michael Rack
 */
public class SourceIntegrityCheckpointCommand extends AbstractSourceIntegrityCommand
{

    private final String _sandbox;
    private String _description;
    private String _label;
    private boolean _labelMembers = false;


    /**
     * generate an si checkpoint command
     * @param server
     * @param port
     * @param username
     * @param password
     * @param sandbox
     * @param description
     */
    public SourceIntegrityCheckpointCommand(final String server, final int port
        , final String username, final String password, final String sandbox
        , final String description, final String label, final boolean labelMembers)
    {
        super( "checkpoint", server, port, username, password );
        _sandbox = sandbox;
        _label = label;
        _description = description;
        _labelMembers = labelMembers;
    }


    @Override
    public ArgumentListBuilder getCommand()
    {
        ArgumentListBuilder cmd = super.getCommand();
        cmd.add("--sandbox=" + _sandbox + File.separator + "project.pj");
        cmd.add("--description=" + _description);
        cmd.add("--label=" + _label);
        if (_labelMembers) {
            cmd.add("--labelMembers");
        }
        cmd.add("--yes");
        cmd.add("--quiet");
        cmd.add("--notify");
        return cmd;
    }

    /*
    public void setDescription(String desc)
    {
        _description = desc;
    }
	
    public String getDescription()
    {
        return _description;
    }

    public boolean getLabelMembers()
    {
        return _labelMembers;
    }

    public void setLabelMembers(boolean b)
    {
        _labelMembers = b;
    }
     */
}
