package hudson.plugins.si;

import hudson.Launcher;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;

/**
 *
 * @author SheeJam
 */
public class SourceIntegrityMakeWritableCommand
implements SourceIntegrityCommand
{

    public SourceIntegrityMakeWritableCommand(Launcher launcher)
    throws IOException
    {
        if ( launcher.isUnix() )
        {
            launcher.getListener().fatalError( "Make Writable command not available on non-Windows machines" );
            throw new IOException( "Make Writable command not available on non-Windows machines" );
        }
    }


    public ArgumentListBuilder getCommand()
    {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        //cmd.add( "attrib -R *.* /s /d" );
        cmd.add( "attrib" );
        cmd.add( "-R" );
        cmd.add( "*.*" );
        cmd.add( "/s" );
        cmd.add( "/d" );
        return cmd;
    }


    public String[] toCommandArray()
    {
        return getCommand().toCommandArray();
    }


    public boolean[] toMaskArray()
    {
        return getCommand().toMaskArray();
    }


    public String toStringWithQuote()
    {
        return getCommand().toStringWithQuote();
    }


    public String toMaskedStringWithQuote()
    {
        throw new UnsupportedOperationException("Not implemented");
    }

}
