package hudson.plugins.si;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

import hudson.model.AbstractBuild;
import hudson.scm.ChangeLogParser;
import hudson.scm.ChangeLogSet;
import hudson.scm.ChangeLogSet.Entry;
import hudson.scm.NullChangeLogParser;
import hudson.util.Digester2;

/*
 * @author Michael Rack
 */
public class SourceIntegrityChangeLogParser
extends ChangeLogParser
{

    @SuppressWarnings("unchecked")
    @Override
    public ChangeLogSet<? extends Entry> parse( AbstractBuild build, File changelogFile )
    throws IOException, SAXException
    {
        List<SourceIntegrityChangeLogEntry> changeSetList = new ArrayList<SourceIntegrityChangeLogEntry>();
        Digester digester = new Digester2();
        digester.push( changeSetList );

        // When digester reads a {{<modification>}} node it will create a {{SourceIntegrityChangeLogEntry}} object
        digester.addObjectCreate( "*/modification", SourceIntegrityChangeLogEntry.class );
        digester.addSetProperties( "*/modification" );
        // Reads the child node {{<comment>}} and uses {{SourceIntegrityChangeLogEntry.setComment()}} to set the value
        digester.addBeanPropertySetter( "*/modification/action" );
        digester.addBeanPropertySetter( "*/modification/member" );
        digester.addBeanPropertySetter( "*/modification/revision" );
        // Reading the {{<date<}} child node will use the {{SourceIntegrityChangeLogEntry.setDateStr()}} method
        // instead of the default {{SourceIntegrityChangeLogEntry.setDate()}}
        digester.addBeanPropertySetter( "*/modification/date", "dateStr" );
        digester.addBeanPropertySetter( "*/modification/cpid" );
        digester.addBeanPropertySetter( "*/modification/cpDesc" );
        digester.addBeanPropertySetter( "*/modification/mksuser" );
        digester.addBeanPropertySetter( "*/modification/msg" );
        // The digested node/change set is added to the list through {{List.add()}}
        digester.addSetNext( "*/modification", "add" );

        // Do the actual parsing
        FileReader reader = new FileReader( changelogFile );
        digester.parse( reader );
        reader.close();
        ChangeLogSet returnSet = new SourceIntegrityChangeLogSet( build, changeSetList );
        if ( returnSet.isEmptySet() )
            returnSet = new NullChangeLogParser().parse( build, changelogFile );
        return returnSet;
    }
}
