import java.net.URL;
import java.security.ProtectionDomain;

import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.WebAppContext;


/**
 * Eclipse: 
 * 		Project->Clean should force a recompile.  From there, run the project
 * 		as a normal java application, and select com.test.JettyLaunch as the main class
 * 
 * WAR:
 * 		Run jettyWar ant task, then use the runJetty ant task, or from command line:
 * 		java -jar [-Dport=8080] test.war
 * 
 * Once started, open a web browser to: http://localhost:8080/hello
 * 
 * @author SheeJam
 */
public class JettyLaunch 
{

	public static void main(String[] args) 
	{
		try 
		{
			new JettyLaunch();
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
		}
	}
	
	public JettyLaunch() throws Exception
	{
		int port = Integer.parseInt(System.getProperty("port", "8080"));
		final Server server = new Server(port);
		
		ProtectionDomain domain = JettyLaunch.class.getProtectionDomain();
        URL location = domain.getCodeSource().getLocation();
        
        // Eclipse outputs classes to BIN file, and launches from that dir
        String webXmlDir = location.toExternalForm().endsWith("bin/") 
        					? location.toExternalForm() + "../etc"
							: location.toExternalForm() + "/WEB-INF";
		
		WebAppContext webapp = new WebAppContext();
        webapp.setContextPath("/");
        webapp.setDescriptor(webXmlDir + "/web.xml");
        webapp.setServer(server);
        webapp.setWar(location.toExternalForm());
        
        server.setHandler(webapp);
        server.start();
        server.join();
	}

}
