import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

/**
 * Hit http://localhost:8080/TestServlet/ and it will create the TEST table
 * Refresh the page, and it will print the table name, verifying that it was created
 */
public class TestServlet extends HttpServlet 
{
	private static final long serialVersionUID = 1L;

    /**
     * Default constructor. 
     */
    public TestServlet() 
    {
        // TODO Auto-generated constructor stub
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	@SuppressWarnings("unused")
	protected void doGet(HttpServletRequest request, HttpServletResponse response) 
	throws ServletException, IOException 
	{
		response.getWriter().println("TestServlet:Enter()");
		
		
		// Add something like the following to context.xml in apache to access the database (put h2 library in apache lib)
		// <Resource driverClassName="org.h2.Driver" maxActive="100" maxIdle="20" name="h2/testdb" password="" type="javax.sql.DataSource" url="jdbc:h2:/h2_database/testdb" username=""/>
		try
		{
			InitialContext cxt = new InitialContext();
			if ( cxt == null ) {
			   throw new ServletException("Context not found!");
			}
			
			// Lookup database connection via JNDI
			DataSource ds = (DataSource) cxt.lookup( "java:/comp/env/h2/testdb" );
	
			if ( ds == null ) {
			   throw new ServletException("Data source not found!");
			}
			
			Connection conn = null;
			Statement stmt = null; // Or PreparedStatement if needed
			ResultSet rs = null;
			try {
				conn = ds.getConnection();
				rs = conn.getMetaData().getTables(
						null,null,"%",null);
						//conn.getMetaData().getCatalogTerm(), null, null, null);
				
				// Print all tables found
				response.getWriter().println("<br/>Tables:");
				boolean foundTestTable = false;
				while (rs.next())
				{
					// h2 method of determining if this is actually a table
					String tableType = rs.getString(4);
					if ( tableType.equalsIgnoreCase("TABLE") )
					{
						// Print the table name
						String tableName = rs.getString(3);
						response.getWriter().println("<br/>&nbsp;&nbsp" + tableName);
						
						// TEST table exists
						if (tableName.equalsIgnoreCase("TEST"))
							foundTestTable = true;
					}
				}
				rs.close();
				rs = null;
				
				// Create table if it doesn't exist
				if (!foundTestTable)
				{
					stmt = conn.createStatement();
					int result = stmt.executeUpdate("CREATE TABLE PUBLIC.TEST (COL1 INTEGER NOT NULL, COL4 DATE, PRIMARY KEY (COL1))");
					response.getWriter().println("<br/>Created table:" + result);
					stmt.close();
					stmt = null;
				}
				
				conn.close(); // Return to connection pool
				conn = null;  // IMPORTANT! ensures database connection doesn't get closed twice by server conn pool
			} catch (SQLException e) {
				e.printStackTrace();
			} finally {
				// Always make sure result sets and statements are closed,
				// and the connection is returned to the pool
				if (rs != null) {
					try {
						rs.close();
					} catch (SQLException e) {
						;
					}
					rs = null;
				}
				if (stmt != null) {
					try {
						stmt.close();
					} catch (SQLException e) {
						;
					}
					stmt = null;
				}
				if (conn != null) {
					try {
						conn.close();
					} catch (SQLException e) {
						;
					}
					conn = null;
				}
			}
		} 
		catch (NamingException e)
		{
			throw new ServletException( e );
		}

		response.getWriter().println("<br/>TestServlet:Exit()");
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) 
	throws ServletException, IOException 
	{
		// TODO Auto-generated method stub
	}

}
