import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.AbstractAction;
import java.awt.event.ActionEvent;

public class Main extends JFrame {

	private static final long serialVersionUID = 1L;
	private JPanel jContentPane = null;
	private JMenuBar jJMenuBar = null;
	private JMenu fileMenuItem = null;
	private JMenuItem exitMenuItem = null;
	
	public static void main(String[] args)
	{
		Main m = new Main();
		m.setSize(new Dimension(200,200));
		m.setLocationRelativeTo(null);
		m.setVisible(true);
	}

	/**
	 * This is the default constructor
	 */
	public Main() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setSize(300, 200);
		this.setJMenuBar(getJJMenuBar());
		this.setContentPane(getJContentPane());
		this.setTitle("JFrame");
		this.setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
		this.addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				closeDown();
			}
		});
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
		}
		return jContentPane;
	}

	/**
	 * This method initializes jJMenuBar	
	 * 	
	 * @return javax.swing.JMenuBar	
	 */
	private JMenuBar getJJMenuBar() {
		if (jJMenuBar == null) {
			jJMenuBar = new JMenuBar();
			jJMenuBar.add(getFileMenuItem());
		}
		return jJMenuBar;
	}

	/**
	 * This method initializes fileMenuItem	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getFileMenuItem() {
		if (fileMenuItem == null) {
			fileMenuItem = new JMenu();
			fileMenuItem.setText("File");
			fileMenuItem.add(getExitMenuItem());
		}
		return fileMenuItem;
	}

	/**
	 * This method initializes exitMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getExitMenuItem() {
		if (exitMenuItem == null) {
			AbstractAction exitAction = new AbstractAction(){
				public void actionPerformed(ActionEvent e) {
					closeDown();
				}};
			exitAction.setEnabled(true);
			exitMenuItem = new JMenuItem();
			exitMenuItem.setAction(exitAction);
			exitMenuItem.setText("Exit");
		}
		return exitMenuItem;
	}
	
	/**
	 * Close
	 */
	private void closeDown()
	{
		int result = JOptionPane.showConfirmDialog(
				null, "Shutdown app?", "Shutdown", JOptionPane.YES_NO_OPTION);
		if (result == JOptionPane.YES_OPTION)
		{
			dispose();
			System.exit(0);
		}
	}

}
