/*
 * Copyright (C) 2007-2009 Alessandro Melandri
 * 
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package net.melandri.jtextfileparser.filters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

import net.melandri.jtextfileparser.beans.Row;
import net.melandri.jtextfileparser.utils.StringUtils;

/**
 * This is the base class for every output file filter. Defines the getRowsSubset method.
 * 
 * @author Alessandro Melandri
 * @since 1.4
 * */
public abstract class OutputFileFilterImpl{

	public String fileName = null;
	public String filePath = null;
	private String textFieldDelimiter = null;
	
	public int[] rows = null;
	public int[] fields = null;
	
	
	public OutputFileFilterImpl(){
		
	}
	
	public void setTextFieldDelimiter(String textFieldDelimiter){
		
		this.textFieldDelimiter = textFieldDelimiter;
		
	}
	
	
	public String cleanField(String fieldValue){
		
		TreeMap textFieldDelimiterMap =  new TreeMap();
		textFieldDelimiterMap.put(textFieldDelimiter, "");
		
		if (textFieldDelimiter != null && fieldValue.indexOf(textFieldDelimiter) > -1){
			return StringUtils.substituteChars(fieldValue, textFieldDelimiterMap);
		}
		
		return fieldValue;
	}
	
	
	
	/**
	 * Parses a list of rows and filters it using information contained into <code>rows</code> and <code>fields</code> arrays
	 * 
	 * @param originalRows ArrayList of rows that should be filtered
	 * @return Returns an ArrayList containing the filtered rows.
	 * */
	public ArrayList getRowsSubset(ArrayList originalRows){
		
		ArrayList rowsSubset = new ArrayList();
		
		if (this.rows != null && this.rows.length > 0) {

			for (int i = 0; i < this.rows.length; i++)
				rowsSubset.add(originalRows.get(this.rows[i]));

		} else {
			rowsSubset = originalRows;
		}
		
		if (this.fields != null && this.fields.length > 0){
			
			Iterator it = rowsSubset.iterator();
			
			while (it.hasNext()){
				Row row = (Row)it.next();
				String[] filteredFields = row.getFields(this.fields);
				row.setFields(filteredFields);
			}			
		}
		
		return rowsSubset;
	}
	
	
	/* -------------------- Getters and Setters -------------------- */
	
	public String getFileName() {
		return fileName;
	}
	
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}
	
	public String getFilePath() {
		return filePath;
	}
	
	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}
	
	public int[] getRows() {
		return rows;
	}

	public void setRows(int[] rows) {
		this.rows = rows;
	}

	public int[] getFields() {
		return fields;
	}

	public void setFields(int[] fields) {
		this.fields = fields;
	}
	
}
