package org.kebabtycoon.model.restaurant.employee;

public class SkillImpl implements Skill {

	public static final int MIN_GRADE = 0;
	public static final int MAX_GRADE = 10;
	
	private int grade;
	private String name;
	
	@Override
	public int getGrade() {

		return grade;
	}

	@Override
	public String getSkillName() {

		return name;
	}

	@Override
	public void setGrade(int grade) throws Exception {

		if (grade < SkillImpl.MIN_GRADE)
			throw new Exception("Grade could not be lower than SkillImpl.MIN_GRADE.");
		
		if (grade > SkillImpl.MAX_GRADE)
			throw new Exception("Grade could not be higher than SkillImpl.MAX_GRADE.");
		
		this.grade = grade;
	}

	@Override
	public void setSkillName(String name) throws Exception {

		if (name == null || name.equals(""))
			throw new Exception("Skill name must be specified.");
		
		this.name = name;
	}

}
