/*
 * ListEntry.java
 *
 * Copyright 2006 Sun Microsystems, Inc. ALL RIGHTS RESERVED Use of 
 * this software is authorized pursuant to the terms of the license 
 * found at http://developers.sun.com/berkeley_license.html .
 *
 */

package com.sun.demo.addressbook;

/**
 *
 * @author John O'Conner
 */
public class PeopleListEntry {

    private String lastName, firstName;
    private int id;
    
    /** Creates a new instance of ListEntry */
    public PeopleListEntry() {
        this("","", -1);
    }
    
    public PeopleListEntry(String lastName, String firstName,  int id) {
        this.lastName = lastName;
        this.firstName = firstName;
        this.id = id;
    }
    
    public String getName() {
        return lastName + ", " + firstName;
    }
    
    
    public String getLastName() {
        return lastName;
    }
    
    public void setLastName(String name) {
        this.lastName = name;
    }
    
    public String getFirstName() {
        return firstName;
    }
    
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }
    
    public int getId() {
        return id;
    }
    
    public void setId(int id) {
        this.id = id;
    }
    
    public String toString( ){
        String value = lastName + ", " + firstName + ": " + id;
        return value;
    }
    
}
