/*
 * AddressActionPanel.java
 *
 * Copyright 2006 Sun Microsystems, Inc. ALL RIGHTS RESERVED Use of 
 * this software is authorized pursuant to the terms of the license 
 * found at http://developers.sun.com/berkeley_license.html .
 */

package com.sun.demo.addressbook;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.EventListenerList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 *
 * @author  John O'Conner
 */
public class GroupActionPanel extends javax.swing.JPanel  {
    
    /**
     * Creates new form AddressActionPanel
     */
    public GroupActionPanel() {
        initComponents();
        listeners = new EventListenerList();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        btnNewGroup = new javax.swing.JButton();
        btnSaveGroup = new javax.swing.JButton();
        btnEditGroup = new javax.swing.JButton();
        btnCancelGroup = new javax.swing.JButton();
        btnDeleteGroup = new javax.swing.JButton();

        setLayout(new java.awt.GridLayout(1, 0));

        btnNewGroup.setText("New");
        btnNewGroup.setActionCommand("NEW_GROUP");
        btnNewGroup.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                newPartActionPerformed(evt);
            }
        });

        add(btnNewGroup);

        btnSaveGroup.setText("Save");
        btnSaveGroup.setActionCommand("SAVE_GROUP");
        btnSaveGroup.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                savePartActionPerformed(evt);
            }
        });

        add(btnSaveGroup);

        btnEditGroup.setText("Edit");
        btnEditGroup.setActionCommand("EDIT_GROUP");
        btnEditGroup.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editPartActionPerformed(evt);
            }
        });

        add(btnEditGroup);

        btnCancelGroup.setText("Cancel");
        btnCancelGroup.setActionCommand("CANCEL_GROUP");
        btnCancelGroup.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelPartActionPerformed(evt);
            }
        });

        add(btnCancelGroup);

        btnDeleteGroup.setText("Delete");
        btnDeleteGroup.setActionCommand("DELETE_GROUP");
        btnDeleteGroup.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deletePartActionPerformed(evt);
            }
        });

        add(btnDeleteGroup);

    }// </editor-fold>//GEN-END:initComponents

    private void newPartActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newPartActionPerformed
        fireActionEvent(evt);
    }//GEN-LAST:event_newPartActionPerformed

    private void cancelPartActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelPartActionPerformed
        fireActionEvent(evt);
    }//GEN-LAST:event_cancelPartActionPerformed

    private void savePartActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_savePartActionPerformed
        fireActionEvent(evt);
    }//GEN-LAST:event_savePartActionPerformed

    private void editPartActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editPartActionPerformed
        fireActionEvent(evt);
    }//GEN-LAST:event_editPartActionPerformed

    private void deletePartActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_deletePartActionPerformed
        fireActionEvent(evt);
    }//GEN-LAST:event_deletePartActionPerformed

    private void fireActionEvent(ActionEvent evt) {
        ActionListener[] listenerList = listeners.getListeners(ActionListener.class);

        for (int i = listenerList.length-1; i>=0; --i) {
            listenerList[i].actionPerformed(evt);
        }
        
    }
    
    public void addActionListener(ActionListener listener) {
        listeners.add(ActionListener.class, listener);
    }
    
    public void removeActionListener(ActionListener listener) {
        if (listeners != null) {
            listeners.remove(ActionListener.class, listener);
        }
    }
    
    EventListenerList listeners;
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnCancelGroup;
    private javax.swing.JButton btnDeleteGroup;
    private javax.swing.JButton btnEditGroup;
    private javax.swing.JButton btnNewGroup;
    private javax.swing.JButton btnSaveGroup;
    // End of variables declaration//GEN-END:variables
    
}
