/*
 * GroupListPanel.java
 * 
 */
package com.sun.demo.addressbook;

import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.event.ListSelectionListener;

/**
 *
 */
public class GroupListPanel extends javax.swing.JPanel {
    private DefaultListCellRenderer renderer;
    private DefaultListModel model;
    
    /** Creates new form GroupListPanel */
    public GroupListPanel() {
//        renderer = new GroupListEntryRenderer();
        renderer = new DefaultListCellRenderer();
        model = new DefaultListModel();
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        groupScrollPane = new javax.swing.JScrollPane();
        groupList = new javax.swing.JList();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.Y_AXIS));

        groupScrollPane.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        groupList.setModel(model);
        groupList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        groupList.setCellRenderer(renderer);
        groupList.setName("groupList");
        groupScrollPane.setViewportView(groupList);

        add(groupScrollPane);

    }// </editor-fold>//GEN-END:initComponents
    
    public void addListEntry(GroupListEntry entry) {
        model.addElement(entry);
    }
    
    public void addListEntries(List<GroupListEntry> list) {
        for(GroupListEntry entry: list) { 
            addListEntry(entry);
        }
    }
    
    public void clearSelection() {
        groupList.clearSelection();
    }
    
    public int getSelectedIndex() {
        return groupList.getSelectedIndex();
    }
    
    public int setSelectedIndex(int index) {
        assert(index >= -1);
        DefaultListModel model = (DefaultListModel)groupList.getModel();
        int size = model.getSize();
        if (index < size) {
            groupList.setSelectedIndex(index);
        } else {
            groupList.setSelectedIndex(size-1);
            index = size -1;
        }
        return index;
    }
    
    public GroupListEntry getSelectedListEntry() {
        GroupListEntry entry = (GroupListEntry)groupList.getSelectedValue();
        return entry;
    }
    
    public int deleteSelectedEntry() {
        int selectedIndex = groupList.getSelectedIndex();
        if (selectedIndex >= 0) {
            DefaultListModel model = (DefaultListModel)groupList.getModel();
            model.remove(selectedIndex);
        }
        return selectedIndex;
    }
    public void addListSelectionListener(ListSelectionListener listener) {
        groupList.addListSelectionListener(listener);
    }
    
    public void removeListSelectionListener(ListSelectionListener listener) {
        groupList.removeListSelectionListener(listener);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JList groupList;
    private javax.swing.JScrollPane groupScrollPane;
    // End of variables declaration//GEN-END:variables
    
}
