/*
 * LppFrame.java
 *
 * Created on December 13, 2006, 4:06 PM
 */
package com.sun.demo.addressbook;

import com.sun.demo.addressbook.db.*;
import java.awt.Image;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/**
 *
 * @author  rhisld
 *
 *       jLabel1.setFont(new java.awt.Font("Tahoma", 1, 11));
 *       jLabel1.setForeground(java.awt.Color.red);
 *       jLabel1.setText("jLabel1 alkjdfa;sldfjk a;sldkfj as;ldfj as;dlfjkas;dlfjkasdk fjh asdklfjhasdlfkhwqeoic wnfoiuwhecoiuw ecoiuwbecouiw becoiuwbe coiwubecoiwuecouiwehc");
 *
 */
public class LppFrame extends javax.swing.JFrame
        implements ActionListener, ListSelectionListener {
    
    private boolean isModified;
    private int selectedEntry = -1;
    private AddressDao addressDAO;
    private PartDao partDAO;
    private GroupDao groupDAO;
    private PartGroupDao partGroupDAO;
    private WindowAdapter windowAdapter;
    private Desktop desktop = null;
    GroupEmailFrame groupEmailFrame = null;
    AddressEmailFrame addressEmailFrame = null;
    
    /** Creates new form LppFrame */
    public LppFrame() {
        try {UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());} catch (Exception e) { }
//        try {UIManager.setLookAndFeel("net.sourceforge.napkinlaf.NapkinLookAndFeel");} catch (Exception e) { }
        initComponents();
        loadFrameIcon();
        
        addressDAO = new AddressDao();
        addressDAO.connect();
        List<PeopleListEntry> entries = addressDAO.getListEntries();
        addressListPanel.addListEntries(entries);
        addressListPanel.addListSelectionListener(this);
        addressActionPanel.addActionListener(this);
        addressPanel.addActionListener(this);
        addressPanel.setEditable(false);
        
        partDAO = new PartDao();
        partDAO.connect();
        List<PartListEntry> partEntries = partDAO.getListEntries();
        partListPanel.addListEntries(partEntries);
        partListPanel.addListSelectionListener(this);
        partPanel.addActionListener(this);
        // for add and remove group membership buttons
        partActionPanel.addActionListener(this);
        partPanel.setEditable(false);
        
        groupDAO = new GroupDao();
        groupDAO.connect();
        List<GroupListEntry> groupEntries = groupDAO.getListEntries();
        groupListPanel.addListEntries(groupEntries);
        groupListPanel.addListSelectionListener(this);
        groupActionPanel.addActionListener(this);
        groupPanel.addActionListener(this);
        groupPanel.setEditable(false);
        partGroupDAO = new PartGroupDao();
        partGroupDAO.connect();
        
        addressPanel.addPartComboBoxEntries(partEntries);
        
        if (Desktop.isDesktopSupported()) {
            desktop = Desktop.getDesktop();
            groupPanel.enableEmail();
            addressPanel.enableEmail();
        }
        
        groupEmailFrame = new GroupEmailFrame(this, true);
        groupEmailFrame.addActionListener(this);
        addressEmailFrame = new AddressEmailFrame(this, true);
        addressEmailFrame.addActionListener(this);
    }
    
    /**
     * Load our own "address book" icon into our frame window.
     */
    private void loadFrameIcon() {
        URL imgUrl = null;
        ImageIcon imgIcon = null;
        imgUrl = LppFrame.class.getResource("resource/addressbook32.gif");
        imgIcon = new ImageIcon(imgUrl);
        Image img = imgIcon.getImage();
        this.setIconImage(img);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        tabGroup = new javax.swing.JTabbedPane();
        addressTab = new javax.swing.JLayeredPane();
        addressPanel = new com.sun.demo.addressbook.AddressPanel();
        addressActionPanel = new com.sun.demo.addressbook.AddressActionPanel();
        addressListPanel = new com.sun.demo.addressbook.AddressListPanel();
        partsTab = new javax.swing.JLayeredPane();
        partListPanel = new com.sun.demo.addressbook.PartListPanel();
        partPanel = new com.sun.demo.addressbook.PartPanel();
        partActionPanel = new com.sun.demo.addressbook.PartActionPanel();
        groupsTab = new javax.swing.JLayeredPane();
        groupPanel = new com.sun.demo.addressbook.GroupPanel();
        groupListPanel = new com.sun.demo.addressbook.GroupListPanel();
        groupActionPanel = new com.sun.demo.addressbook.GroupActionPanel();
        lblStatusBar = new javax.swing.JLabel();
        jMenuBar1 = new javax.swing.JMenuBar();
        fileMenu = new javax.swing.JMenu();
        fileExit = new javax.swing.JMenuItem();
        toolsMenu = new javax.swing.JMenu();
        emailAddressMenuItem = new javax.swing.JMenuItem();
        emailGroupMenuItem = new javax.swing.JMenuItem();
        emailAllMenuItem = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("LPP 2007 Information");
        setLocationByPlatform(true);
        setResizable(false);
        addressPanel.setBounds(201, 0, 640, 510);
        addressTab.add(addressPanel, javax.swing.JLayeredPane.DEFAULT_LAYER);

        addressActionPanel.setBounds(500, 510, -1, -1);
        addressTab.add(addressActionPanel, javax.swing.JLayeredPane.DEFAULT_LAYER);

        addressListPanel.setBounds(0, 0, 200, 540);
        addressTab.add(addressListPanel, javax.swing.JLayeredPane.DEFAULT_LAYER);

        tabGroup.addTab("People", addressTab);

        partListPanel.setBounds(0, 0, 200, 540);
        partsTab.add(partListPanel, javax.swing.JLayeredPane.DEFAULT_LAYER);

        partPanel.setBounds(200, 0, 630, 510);
        partsTab.add(partPanel, javax.swing.JLayeredPane.DEFAULT_LAYER);

        partActionPanel.setBounds(500, 510, -1, -1);
        partsTab.add(partActionPanel, javax.swing.JLayeredPane.DEFAULT_LAYER);

        tabGroup.addTab("Parts", partsTab);

        groupPanel.setBounds(210, 0, 620, 510);
        groupsTab.add(groupPanel, javax.swing.JLayeredPane.DEFAULT_LAYER);

        groupListPanel.setBounds(0, 0, 200, 540);
        groupsTab.add(groupListPanel, javax.swing.JLayeredPane.DEFAULT_LAYER);

        groupActionPanel.setBounds(500, 510, -1, -1);
        groupsTab.add(groupActionPanel, javax.swing.JLayeredPane.DEFAULT_LAYER);

        tabGroup.addTab("Groups", groupsTab);

        lblStatusBar.setBorder(javax.swing.BorderFactory.createLineBorder(java.awt.Color.lightGray));

        fileMenu.setMnemonic('F');
        fileMenu.setText("File");
        fileExit.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F4, java.awt.event.InputEvent.ALT_MASK));
        fileExit.setMnemonic('X');
        fileExit.setText("Exit");
        fileExit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fileExitActionPerformed(evt);
            }
        });

        fileMenu.add(fileExit);

        jMenuBar1.add(fileMenu);

        toolsMenu.setText("Tools");
        toolsMenu.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                toolsMenuActionPerformed(evt);
            }
        });

        emailAddressMenuItem.setText("Email People");
        emailAddressMenuItem.setActionCommand("EMAIL_ADDRESS");
        emailAddressMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                emailAddressMenuItemActionPerformed(evt);
            }
        });

        toolsMenu.add(emailAddressMenuItem);

        emailGroupMenuItem.setText("Email Groups");
        emailGroupMenuItem.setActionCommand("EMAIL_GROUPS");
        emailGroupMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                emailGroupMenuItemActionPerformed(evt);
            }
        });

        toolsMenu.add(emailGroupMenuItem);

        emailAllMenuItem.setText("Email  All");
        emailAllMenuItem.setActionCommand("EMAIL_ALL");
        emailAllMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                emailAllMenuItemActionPerformed(evt);
            }
        });

        toolsMenu.add(emailAllMenuItem);

        jMenuBar1.add(toolsMenu);

        setJMenuBar(jMenuBar1);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(tabGroup, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 844, Short.MAX_VALUE)
            .add(lblStatusBar, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 844, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(tabGroup, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 569, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(lblStatusBar, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 27, Short.MAX_VALUE))
        );
        pack();
    }// </editor-fold>//GEN-END:initComponents
    
    private void emailAddressMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_emailAddressMenuItemActionPerformed
        addressEmailFrame.refreshAddressList();
        addressEmailFrame.setVisible(true);
    }//GEN-LAST:event_emailAddressMenuItemActionPerformed
    
    private void emailAllMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_emailAllMenuItemActionPerformed
        emailAll();
    }//GEN-LAST:event_emailAllMenuItemActionPerformed
    
    private void emailGroupMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_emailGroupMenuItemActionPerformed
        groupEmailFrame.refreshGroupList();
        groupEmailFrame.setVisible(true);
    }//GEN-LAST:event_emailGroupMenuItemActionPerformed
    
    private void toolsMenuActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_toolsMenuActionPerformed
// TODO add your handling code here:
    }//GEN-LAST:event_toolsMenuActionPerformed
    
    private void cancelAddress() {
        addressPanel.clear();
        addressPanel.setEditable(false);
        PeopleListEntry entry = addressListPanel.getSelectedListEntry();
        if (entry != null) {
            int id = entry.getId();
            Address address = addressDAO.getAddress(id);
            addressPanel.setAddress(address);
        }
    }
    
    private void newAddress(){
        addressPanel.clear();
        addressPanel.setEditable(true);
        addressListPanel.clearSelection();
    }
    
    private void deleteAddress() {
        int id = addressPanel.getId();
        if (id != -1) {
            addressDAO.deleteAddress(id);
            int selectedIndex = addressListPanel.deleteSelectedEntry();
            if (selectedIndex >= 0) {
                PeopleListEntry entry = addressListPanel.getSelectedListEntry();
                if (entry != null) {
                    id = entry.getId();
                    Address address = addressDAO.getAddress(id);
                    addressPanel.setAddress(address);
                } else {
                    addressPanel.clear();
                }
            }
        } else {
            addressPanel.clear();
        }
        addressPanel.setEditable(false);
    }
    
    private void editAddress() {
        int selected = addressListPanel.getSelectedIndex();
        if (selected >=0) {
            addressPanel.setEditable(true);
        } else {
            lblStatusBar.setText("Select a Person in the Person List to edit");
        }
    }
    
    private void saveAddress() {
        if (addressPanel.isEditable()) {
            Address address = addressPanel.getAddress();
            int id = address.getId();
            String lname = address.getLastName();
            String fname = address.getFirstName();
            if (id == -1) {
                id = addressDAO.createAddress(address);
                address.setId(id);
                lblStatusBar.setText("Added a new person: " + fname + " " + lname);
                
                PeopleListEntry entry = new PeopleListEntry(lname, fname, id);
                addressListPanel.addPeopleListEntry(entry);
            } else {
                addressDAO.updateAddress(address);
                lblStatusBar.setText("Saved: " + fname + " " + lname);
                PeopleListEntry entry = addressListPanel.getSelectedListEntry();
                entry.setFirstName(fname);
                entry.setLastName(lname);
                addressListPanel.repaint();
            }
            addressPanel.setEditable(false);
        }
    }
    
    private void cancelPart() {
        partPanel.clear();
        partPanel.setEditable(false);
        PartListEntry entry = partListPanel.getSelectedListEntry();
        if (entry != null) {
            int id = entry.getId();
            Part part = partDAO.getPart(id);
            partPanel.setPart(part);
            List<GroupListEntry> assignedGroupEntries = partGroupDAO.getAssignedGroupEntries(part.getId());
            partPanel.setAssignedGroupEntries(assignedGroupEntries);
            List<GroupListEntry> availableGroupEntries = partGroupDAO.getAvailableGroupEntries(part.getId());
            partPanel.setAvailableGroupEntries(availableGroupEntries);
        }
    }
    
    private void newPart(){
        partPanel.clear();
        partPanel.setEditable(true);
        List<GroupListEntry> availableGroupEntries = partGroupDAO.getAvailableGroupEntries(-1);
        partPanel.setAvailableGroupEntries(availableGroupEntries);
        partListPanel.clearSelection();
    }
    
    private void editPart() {
        int selected = partListPanel.getSelectedIndex();
        if (selected >=0) {
            partPanel.setEditable(true);
        } else {
            lblStatusBar.setText("Select a Part in the Part List to edit");
        }
    }
    
    private void deletePart() {
        int id = partPanel.getId();
        if (id != -1) {
            partDAO.deletePart(id);
            int selectedIndex = partListPanel.deleteSelectedEntry();
            if (selectedIndex >= 0) {
                PartListEntry entry = partListPanel.getSelectedListEntry();
                if (entry != null) {
                    id = entry.getId();
                    Part part = partDAO.getPart(id);
                    partPanel.setPart(part);
                } else {
                    partPanel.clear();
                }
            }
        } else {
            partPanel.clear();
        }
        partPanel.setEditable(false);
    }
    
    private void savePart() {
        if (partPanel.isEditable()) {
            Part part = partPanel.getPart();
            int id = part.getId();
            String partName = part.getPartName();
            if (id == -1) {
                id = partDAO.createPart(part);
                part.setId(id);
                lblStatusBar.setText("Added a new part: " + partName);
                PartListEntry entry = new PartListEntry(partName, id);
                partListPanel.addListEntry(entry);
                addressPanel.addPartComboBoxEntry(entry);
            } else {
                partDAO.editPart(part);
                lblStatusBar.setText("Saved: " + partName);
                PartListEntry entry = partListPanel.getSelectedListEntry();
                entry.setPartName(partName);
            }
            partPanel.setEditable(false);
        }
    }
    
    private void cancelGroup() {
        groupPanel.clear();
        groupPanel.setEditable(false);
        GroupListEntry entry = groupListPanel.getSelectedListEntry();
        if (entry != null) {
            int id = entry.getId();
            Group group = groupDAO.getGroup(id);
            groupPanel.setGroup(group);
        }
    }
    
    private void newGroup(){
        groupPanel.clear();
        groupPanel.setEditable(true);
        groupListPanel.clearSelection();
    }
    
    private void editGroup() {
        int selected = groupListPanel.getSelectedIndex();
        if (selected >= 0) {
            groupPanel.setEditable(true);
        } else {
            lblStatusBar.setText("Select a Group in the Group List to edit");
        }
    }
    
    private void deleteGroup() {
        int id = groupPanel.getId();
        if (id != -1) {
            groupDAO.deleteGroup(id);
            int selectedIndex = groupListPanel.deleteSelectedEntry();
            if (selectedIndex >= 0) {
                GroupListEntry entry = groupListPanel.getSelectedListEntry();
                if (entry != null) {
                    id = entry.getId();
                    Group group = groupDAO.getGroup(id);
                    groupPanel.setGroup(group);
                } else {
                    groupPanel.clear();
                }
            }
            partPanel.refreshGroupLists(partGroupDAO);
        } else {
            groupPanel.clear();
        }
        groupPanel.setEditable(false);
    }
    
    private void saveGroup() {
        if (groupPanel.isEditable()) {
            Group group = groupPanel.getGroup();
            int id = group.getId();
            String groupName = group.getGroupName();
            if (id == -1) {
                id = groupDAO.createGroup(group);
                group.setId(id);
                lblStatusBar.setText("Added a new group: " + groupName);
                GroupListEntry entry = new GroupListEntry(groupName, id);
                groupListPanel.addListEntry(entry);
                // Select new entry in
            } else {
                groupDAO.editGroup(group);
                lblStatusBar.setText("Saved: " + groupName);
                GroupListEntry entry = groupListPanel.getSelectedListEntry();
                entry.setGroupName(groupName);
                groupListPanel.repaint();
            }
            groupPanel.setEditable(false);
        }
    }
    
    private void addGroup() {
        if (partPanel.isEditable()) {
            Part part = partPanel.getPart();
            int partId = part.getId();
            PartGroup partGroup = new PartGroup();
            if (partId != -1) {
                partGroup.setPartId(partId);
                GroupListEntry groupListEntry = partPanel.getSelectedAvailableGroup();
                if (groupListEntry != null) {
                    partGroup.setGroupId(groupListEntry.getId());
                    partGroupDAO.createPartGroup(partGroup);
                }
            }
            List<GroupListEntry> assignedGroupEntries = partGroupDAO.getAssignedGroupEntries(partId);
            partPanel.setAssignedGroupEntries(assignedGroupEntries);
            List<GroupListEntry> availableGroupEntries = partGroupDAO.getAvailableGroupEntries(partId);
            partPanel.setAvailableGroupEntries(availableGroupEntries);
        }
    }
    
    private void removeGroup() {
        if (partPanel.isEditable()) {
            Part part = partPanel.getPart();
            int partId = part.getId();
            PartGroup partGroup = new PartGroup();
            if (partId != -1) {
                partGroup.setPartId(partId);
                GroupListEntry groupListEntry = partPanel.getSelectedAssignedGroup();
                if (groupListEntry != null) {
                    partGroup.setGroupId(groupListEntry.getId());
                    partGroupDAO.deletePartGroup(partGroup);
                }
            }
            List<GroupListEntry> assignedGroupEntries = partGroupDAO.getAssignedGroupEntries(partId);
            partPanel.setAssignedGroupEntries(assignedGroupEntries);
            List<GroupListEntry> availableGroupEntries = partGroupDAO.getAvailableGroupEntries(partId);
            partPanel.setAvailableGroupEntries(availableGroupEntries);
        }
    }
    
    private void emailAddress() {
        lblStatusBar.setText("Creating Email...");
        String mailTo = addressPanel.getAddress().getEmail();
        URI uriMailTo = null;
        
        if (mailTo != null) {
            try {
                if (mailTo.length() > 0) {
                    uriMailTo = new URI("mailto", mailTo.toString(), null);
                    desktop.mail(uriMailTo);
                } else {
                    lblStatusBar.setText("There is no email address for this person");
                }
            } catch(IOException ioe) {
                ioe.printStackTrace();
                lblStatusBar.setText("Error Creating Email List (IO Exception...");
            } catch(URISyntaxException use) {
                use.printStackTrace();
                lblStatusBar.setText("Error Creating Email List (URI Syntax...");
            }
        }
    }
    
    private void emailAddresses() {
        addressEmailFrame.setLblEmailStatus("Creating Email...");
        Object peopleListEntries[] = addressEmailFrame.getSelectedListEntries();
        PeopleListEntry peopleListEntry = null;
        URI uriMailTo = null;
        StringBuffer mailTo = new StringBuffer();
        HashSet emailAddresses = new HashSet();
        
        for (int i = 0; i < peopleListEntries.length; i++) {
            peopleListEntry = (PeopleListEntry) peopleListEntries[i];
            int id = peopleListEntry.getId();
            if (id != -1) {
                Address address = addressDAO.getAddress(id);
                emailAddresses.add(address.getEmail());
            }
        }
        
        for (Iterator it = emailAddresses.iterator(); it.hasNext();) {
            mailTo.append((String) it.next());
            mailTo.append(";");
        }
        
        try {
            if (mailTo.length() > 0) {
                uriMailTo = new URI("mailto", mailTo.toString(), null);
                desktop.mail(uriMailTo);
            } else {
                groupEmailFrame.setLblEmailStatus("There are no email addresses for the selected people");
            }
        } catch(IOException ioe) {
            ioe.printStackTrace();
            groupEmailFrame.setLblEmailStatus("Error Creating Email List (IO Exception...");
        } catch(URISyntaxException use) {
            use.printStackTrace();
            groupEmailFrame.setLblEmailStatus("Error Creating Email List (URI Syntax...");
        }
    }
    
    private void emailGroup() {
        groupPanel.setLblEmailStatus("Creating Email for Group...");
        Group group = groupPanel.getGroup();
        URI uriMailTo = null;
        StringBuffer mailTo = new StringBuffer();
        
        int groupId = group.getId();
        if (groupId != -1) {
            AbstractCollection<String> emailAddresses = groupDAO.getEmailListForGroup(groupId);
            for (Iterator it = emailAddresses.iterator(); it.hasNext();) {
                String emailAddress = (String) it.next();
                mailTo.append(emailAddress);
                mailTo.append(";");
            }
            try {
                if (mailTo.length() > 0) {
                    uriMailTo = new URI("mailto", mailTo.toString(), null);
                    desktop.mail(uriMailTo);
                } else {
                    groupPanel.setLblEmailStatus("There are no email addresses for the selected Group");
                }
            } catch(IOException ioe) {
                ioe.printStackTrace();
                groupPanel.setLblEmailStatus("Error Creating Email List (IO Exception...");
            } catch(URISyntaxException use) {
                use.printStackTrace();
                groupPanel.setLblEmailStatus("Error Creating Email List (URI Syntax...");
            }
        } else {
            groupPanel.setLblEmailStatus("No Group Selected...");
        }
    }
    
    private void emailAll() {
//        lblStatusBar.setFont(new java.awt.Font("Tahoma", 1, 11));
//        lblStatusBar.setForeground(java.awt.Color.red);
//        lblStatusBar.setText("Label Text");
        lblStatusBar.setText("Creating Email for Everyone...");
        URI uriMailTo = null;
        StringBuffer mailTo = new StringBuffer();
        
        AbstractCollection<String> emailAddresses = addressDAO.getEmailListForAll();
        for (Iterator it = emailAddresses.iterator(); it.hasNext();) {
            String emailAddress = (String) it.next();
            mailTo.append(emailAddress);
            mailTo.append("; ");
        }
        try {
            if (mailTo.length() > 0) {
                uriMailTo = new URI("mailto", mailTo.toString(), null);
                desktop.mail(uriMailTo);
            } else {
                lblStatusBar.setText("There are no email addresses in the system");
            }
        } catch(IOException ioe) {
            ioe.printStackTrace();
            lblStatusBar.setText("Error Creating Email List (IO Exception");
        } catch(URISyntaxException use) {
            use.printStackTrace();
            lblStatusBar.setText("Error Creating Email List (URI Syntax");
        }
        lblStatusBar.setText("Created Email");
    }
    
    private void emailGroups() {
        groupEmailFrame.setLblEmailStatus("Creating Email for Group...");
        Object groupListEntries[] = groupEmailFrame.getSelectedListEntries();
        GroupListEntry groupListEntry = null;
        URI uriMailTo = null;
        StringBuffer mailTo = new StringBuffer();
        HashSet emailAddresses = new HashSet();
        
        for (int i = 0; i < groupListEntries.length; i++) {
            groupListEntry = (GroupListEntry) groupListEntries[i];
            int groupId = groupListEntry.getId();
            if (groupId != -1) {
                emailAddresses.addAll(groupDAO.getEmailListForGroup(groupId));
            }
        }
        
        for (Iterator it = emailAddresses.iterator(); it.hasNext();) {
            mailTo.append((String) it.next());
            mailTo.append(";");
        }
        
        try {
            if (mailTo.length() > 0) {
                uriMailTo = new URI("mailto", mailTo.toString(), null);
                desktop.mail(uriMailTo);
            } else {
                groupEmailFrame.setLblEmailStatus("There are no email addresses for the selected Group");
            }
        } catch(IOException ioe) {
            ioe.printStackTrace();
            groupEmailFrame.setLblEmailStatus("Error Creating Email List (IO Exception...");
        } catch(URISyntaxException use) {
            use.printStackTrace();
            groupEmailFrame.setLblEmailStatus("Error Creating Email List (URI Syntax...");
        }
    }
    
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        lblStatusBar.setText("Action: " + actionCommand);
        System.out.println("ActionEvent: " + actionCommand);
        groupPanel.setLblEmailStatus("");
        if (actionCommand.equalsIgnoreCase("CANCEL_ADDRESS")) {
            cancelAddress();
        } else if (actionCommand.equalsIgnoreCase("NEW_ADDRESS")) {
            newAddress();
        } else if (actionCommand.equalsIgnoreCase("DELETE_ADDRESS")) {
            deleteAddress();
        } else if (actionCommand.equalsIgnoreCase("EDIT_ADDRESS")) {
            editAddress();
        } else if (actionCommand.equalsIgnoreCase("SAVE_ADDRESS")) {
            saveAddress();
            
        } else if (actionCommand.equalsIgnoreCase("CANCEL_PART")) {
            cancelPart();
        } else if (actionCommand.equalsIgnoreCase("NEW_PART")) {
            newPart();
        } else if (actionCommand.equalsIgnoreCase("DELETE_PART")) {
            deletePart();
        } else if (actionCommand.equalsIgnoreCase("EDIT_PART")) {
            editPart();
        } else if (actionCommand.equalsIgnoreCase("SAVE_PART")) {
            savePart();
            
        } else if (actionCommand.equalsIgnoreCase("CANCEL_GROUP")) {
            cancelGroup();
        } else if (actionCommand.equalsIgnoreCase("NEW_GROUP")) {
            newGroup();
        } else if (actionCommand.equalsIgnoreCase("DELETE_GROUP")) {
            deleteGroup();
        } else if (actionCommand.equalsIgnoreCase("EDIT_GROUP")) {
            editGroup();
        } else if (actionCommand.equalsIgnoreCase("SAVE_GROUP")) {
            saveGroup();
            
        } else if (actionCommand.equalsIgnoreCase("ADD_GROUP")) {
            addGroup();
        } else if (actionCommand.equalsIgnoreCase("REMOVE_GROUP")) {
            removeGroup();
            
        } else if (actionCommand.equalsIgnoreCase("EMAIL_ADDRESS")) {
            emailAddress();
        } else if (actionCommand.equalsIgnoreCase("EMAIL_ADDRESSES")) {
            emailAddresses();
        } else if (actionCommand.equalsIgnoreCase("EMAIL_GROUP")) {
            emailGroup();
        } else if (actionCommand.equalsIgnoreCase("EMAIL_GROUPS")) {
            emailGroups();
        }
    }
    
    // Selection event for JLists
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        
        JList entryList = (JList) e.getSource();
        selectedEntry = entryList.getSelectedIndex();
        if (entryList.getName().equals("partList")) {
            PartListEntry entry = (PartListEntry)entryList.getSelectedValue();
            if (entry != null) {
                int partId = entry.getId();
                Part part = partDAO.getPart(partId);
                partPanel.setPart(part);
                List<GroupListEntry> assignedGroupEntries = partGroupDAO.getAssignedGroupEntries(partId);
                partPanel.setAssignedGroupEntries(assignedGroupEntries);
                List<GroupListEntry> availableGroupEntries = partGroupDAO.getAvailableGroupEntries(partId);
                partPanel.setAvailableGroupEntries(availableGroupEntries);
            } else {
                partPanel.clear();
            }
        } else if (entryList.getName().equals("addressList")) {
            PeopleListEntry entry = (PeopleListEntry)entryList.getSelectedValue();
            if (entry != null) {
                int id = entry.getId();
                Address address = addressDAO.getAddress(id);
                addressPanel.setAddress(address);
            } else {
                addressPanel.clear();
            }
        } else if (entryList.getName().equals("groupList")) {
            GroupListEntry entry = (GroupListEntry)entryList.getSelectedValue();
            if (entry != null) {
                int id = entry.getId();
                Group group = groupDAO.getGroup(id);
                groupPanel.setGroup(group);
//                groupPanel.setEditable(true);
            } else {
                addressPanel.clear();
            }
        }
    }
    
    private void fileExitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fileExitActionPerformed
/*        if (isModified) {
            //ask user if they want to save current config file
            int choice = JOptionPane.showConfirmDialog(this, resourceBundle.getString("Close_save"), "Save Config",
                    JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
            if (choice == JOptionPane.YES_OPTION) {
                if (this.file == null) {
                    saveConfigAs();
                } else {
                    saveConfig();
                }
            }
        }
 */
        this.dispose();
    }//GEN-LAST:event_fileExitActionPerformed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new LppFrame().setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private com.sun.demo.addressbook.AddressActionPanel addressActionPanel;
    private com.sun.demo.addressbook.AddressListPanel addressListPanel;
    private com.sun.demo.addressbook.AddressPanel addressPanel;
    private javax.swing.JLayeredPane addressTab;
    private javax.swing.JMenuItem emailAddressMenuItem;
    private javax.swing.JMenuItem emailAllMenuItem;
    private javax.swing.JMenuItem emailGroupMenuItem;
    private javax.swing.JMenuItem fileExit;
    private javax.swing.JMenu fileMenu;
    private com.sun.demo.addressbook.GroupActionPanel groupActionPanel;
    private com.sun.demo.addressbook.GroupListPanel groupListPanel;
    private com.sun.demo.addressbook.GroupPanel groupPanel;
    private javax.swing.JLayeredPane groupsTab;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JLabel lblStatusBar;
    private com.sun.demo.addressbook.PartActionPanel partActionPanel;
    private com.sun.demo.addressbook.PartListPanel partListPanel;
    private com.sun.demo.addressbook.PartPanel partPanel;
    private javax.swing.JLayeredPane partsTab;
    private javax.swing.JTabbedPane tabGroup;
    private javax.swing.JMenu toolsMenu;
    // End of variables declaration//GEN-END:variables
}
