/*
 * AddressActionPanel.java
 *
 * Copyright 2006 Sun Microsystems, Inc. ALL RIGHTS RESERVED Use of 
 * this software is authorized pursuant to the terms of the license 
 * found at http://developers.sun.com/berkeley_license.html .
 */

package com.sun.demo.addressbook;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.EventListenerList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 *
 * @author  John O'Conner
 */
public class PartActionPanel extends javax.swing.JPanel  {
    
    /**
     * Creates new form AddressActionPanel
     */
    public PartActionPanel() {
        initComponents();
        listeners = new EventListenerList();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        btnNewPart = new javax.swing.JButton();
        btnSavePart = new javax.swing.JButton();
        btnEditPart = new javax.swing.JButton();
        btnCancelPart = new javax.swing.JButton();
        btnDeletePart = new javax.swing.JButton();

        setLayout(new java.awt.GridLayout(1, 0));

        btnNewPart.setText("New");
        btnNewPart.setActionCommand("NEW_PART");
        btnNewPart.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                newPartActionPerformed(evt);
            }
        });

        add(btnNewPart);

        btnSavePart.setText("Save");
        btnSavePart.setActionCommand("SAVE_PART");
        btnSavePart.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                savePartActionPerformed(evt);
            }
        });

        add(btnSavePart);

        btnEditPart.setText("Edit");
        btnEditPart.setActionCommand("EDIT_PART");
        btnEditPart.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editPartActionPerformed(evt);
            }
        });

        add(btnEditPart);

        btnCancelPart.setText("Cancel");
        btnCancelPart.setActionCommand("CANCEL_PART");
        btnCancelPart.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelPartActionPerformed(evt);
            }
        });

        add(btnCancelPart);

        btnDeletePart.setText("Delete");
        btnDeletePart.setActionCommand("DELETE_PART");
        btnDeletePart.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deletePartActionPerformed(evt);
            }
        });

        add(btnDeletePart);

    }// </editor-fold>//GEN-END:initComponents

    private void newPartActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newPartActionPerformed
        fireActionEvent(evt);
    }//GEN-LAST:event_newPartActionPerformed

    private void cancelPartActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelPartActionPerformed
        fireActionEvent(evt);
    }//GEN-LAST:event_cancelPartActionPerformed

    private void savePartActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_savePartActionPerformed
        fireActionEvent(evt);
    }//GEN-LAST:event_savePartActionPerformed

    private void editPartActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editPartActionPerformed
        fireActionEvent(evt);
    }//GEN-LAST:event_editPartActionPerformed

    private void deletePartActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_deletePartActionPerformed
        fireActionEvent(evt);
    }//GEN-LAST:event_deletePartActionPerformed

    private void fireActionEvent(ActionEvent evt) {
        ActionListener[] listenerList = listeners.getListeners(ActionListener.class);

        for (int i = listenerList.length-1; i>=0; --i) {
            listenerList[i].actionPerformed(evt);
        }
        
    }
    
    public void addActionListener(ActionListener listener) {
        listeners.add(ActionListener.class, listener);
    }
    
    public void removeActionListener(ActionListener listener) {
        if (listeners != null) {
            listeners.remove(ActionListener.class, listener);
        }
    }
    
    EventListenerList listeners;
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnCancelPart;
    private javax.swing.JButton btnDeletePart;
    private javax.swing.JButton btnEditPart;
    private javax.swing.JButton btnNewPart;
    private javax.swing.JButton btnSavePart;
    // End of variables declaration//GEN-END:variables
    
}
