/*
 * AddressListPanel.java
 *
 */
package com.sun.demo.addressbook;

import com.sun.demo.addressbook.PeopleListEntry;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionListener;

/**
 *
 */
public class AddressListPanel extends javax.swing.JPanel {
    private PeopleListEntryRenderer renderer;
    private DefaultListModel peopleListModel;
    
    /** Creates new form AddressListPanel */
    public AddressListPanel() {
        renderer = new PeopleListEntryRenderer();
        peopleListModel = new DefaultListModel();
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        scrollPane = new javax.swing.JScrollPane();
        addressList = new javax.swing.JList();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.Y_AXIS));

        scrollPane.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        addressList.setModel(peopleListModel);
        addressList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        addressList.setCellRenderer(renderer);
        addressList.setName("addressList");
        scrollPane.setViewportView(addressList);

        add(scrollPane);

    }// </editor-fold>//GEN-END:initComponents
    
    public void addPeopleListEntry(PeopleListEntry entry) {
        peopleListModel.addElement(entry);
    }
    
    public void addListEntries(List<PeopleListEntry> list) {
        for(PeopleListEntry entry: list) {
            addPeopleListEntry(entry);
        }
    }
    
    public int getSelectedIndex() {
        return addressList.getSelectedIndex();
    }
    
    public int setSelectedIndex(int index) {
        assert(index >= -1);
        DefaultListModel model = (DefaultListModel)addressList.getModel();
        int size = model.getSize();
        if (index < size) {
            addressList.setSelectedIndex(index);
        } else {
            addressList.setSelectedIndex(size-1);
            index = size -1;
        }
        return index;
    }
    
    public PeopleListEntry getSelectedListEntry() {
        PeopleListEntry entry = (PeopleListEntry)addressList.getSelectedValue();
        return entry;
    }
    
    public int deleteSelectedEntry() {
        int selectedIndex = addressList.getSelectedIndex();
        if (selectedIndex >= 0) {
            DefaultListModel model = (DefaultListModel)addressList.getModel();
            model.remove(selectedIndex);
        }
        return selectedIndex;
    }
    public void addListSelectionListener(ListSelectionListener listener) {
        addressList.addListSelectionListener(listener);
    }
    
    public void removeListSelectionListener(ListSelectionListener listener) {
        addressList.removeListSelectionListener(listener);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JList addressList;
    private javax.swing.JScrollPane scrollPane;
    // End of variables declaration//GEN-END:variables
}
