/*
 * ListEntry.java
 *
 * Copyright 2006 Sun Microsystems, Inc. ALL RIGHTS RESERVED Use of
 * this software is authorized pursuant to the terms of the license
 * found at http://developers.sun.com/berkeley_license.html .
 *
 */

package com.sun.demo.addressbook;

/**
 *
 * @author John O'Conner
 */
public class PartListEntry {
    
    private String partName;
    private int id;
    
    /** Creates a new instance of ListEntry */
    public PartListEntry() {
        this("", -1);
    }
    
    public PartListEntry(String partName, int id) {
        this.partName = partName;
        this.id = id;
    }
    
    public String getName() {
        return partName;
    }
    
    public String getPartName() {
        return partName;
    }
    
    public void setPartName(String partName) {
        this.partName = partName;
    }
    
    public int getId() {
        return id;
    }
    
    public void setId(int id) {
        this.id = id;
    }
    
    public String toString( ){
        String value = partName + ": " + id;
        return value;
    }
}
