/*
 * GroupListEntry.java
 *
 */

package org.lpp;

import org.lpp.util.HashCodeUtil;

/**
 *
 */
public class GroupListEntry implements Comparable<GroupListEntry> {
    private String groupName;
    private int id;
    
    /** Creates a new instance of ListEntry */
    public GroupListEntry() {
        this("", -1);
    }
    
    public GroupListEntry(String groupName, int id) {
        this.groupName = groupName;
        this.id = id;
    }
    
    public String getName() {
        return groupName;
    }
    
    public String getGroupName() {
        return groupName;
    }
    
    public void setGroupName(String partName) {
        this.groupName = partName;
    }
    
    public int getId() {
        return id;
    }
    
    public void setId(int id) {
        this.id = id;
    }
    
    public String toString( ){
//        String value = groupName + ": " + id;
        return groupName;
    }
    
    public int hashCode() {
        int result = HashCodeUtil.SEED;
        result = HashCodeUtil.hash( result, groupName );
        result = HashCodeUtil.hash( result, id );
        return result;
    }
    
    public boolean equals(Object entry) {
        if (entry == null) {
            return false;
        }
        if (entry instanceof GroupListEntry) {
            return this.equals((GroupListEntry)entry);
        } else {
            return false;
        }
    }
    
    public boolean equals(GroupListEntry entry) {
        boolean result = true;
        if (! this.groupName.equals(entry.getGroupName())) {
            result = false;
        }
        if (this.id != entry.getId()) {
            result = false;
        }
        return result;
    }
    
    public int compareTo(GroupListEntry entry) {
        return this.getGroupName().compareTo(entry.getGroupName());
    }
}
