/*
 * ListEntry.java
 *
 * Copyright 2006 Sun Microsystems, Inc. ALL RIGHTS RESERVED Use of
 * this software is authorized pursuant to the terms of the license
 * found at http://developers.sun.com/berkeley_license.html .
 *
 */
package org.lpp;

import org.lpp.util.HashCodeUtil;

/**
 *
 * @author John O'Conner
 */
public class PeopleListEntry implements Comparable<PeopleListEntry> {

    private String lastName,  firstName;
    private int id;

    /** Creates a new instance of ListEntry */
    public PeopleListEntry() {
        this("", "", -1);
    }

    public PeopleListEntry(String lastName, String firstName, int id) {
        this.lastName = lastName;
        this.firstName = firstName;
        this.id = id;
    }

    public String getName() {
        return lastName + ", " + firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String name) {
        this.lastName = name;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String toString() {
        String value = lastName + ", " + firstName;
        return value;
    }

    public int hashCode() {
        int result = HashCodeUtil.SEED;
        result = HashCodeUtil.hash(result, lastName);
        result = HashCodeUtil.hash(result, firstName);
        result = HashCodeUtil.hash(result, id);
        return result;
    }

    public boolean equals(Object entry) {
        if (entry == null) {
            return false;
        }
        if (entry instanceof PeopleListEntry) {
            return this.equals((PeopleListEntry) entry);
        } else {
            return false;
        }
    }

    public boolean equals(PeopleListEntry entry) {
        boolean result = true;
        if (!this.lastName.equals(entry.getLastName())) {
            result = false;
        }
        if (!this.firstName.equals(entry.getFirstName())) {
            result = false;
        }
        if (this.id != entry.getId()) {
            result = false;
        }
        return result;
    }

    public int compareTo(PeopleListEntry entry) {
        int lastCmp = this.getLastName().compareTo(entry.getLastName());
        if (lastCmp != 0) {
            return lastCmp;
        }

        lastCmp = this.getFirstName().compareTo(entry.getFirstName());
        if (lastCmp != 0) {
            return lastCmp;
        }

        if (this.getId() == entry.getId()) {
            return 0;
        }

        if (this.getId() < entry.getId()) {
            return -1;
        } else {
            return 1;
        }
    }
}
