package lsp;

import java.nio.ByteBuffer;

public class LspMessage {
	private short msgType;
	private short connId;
	private short seqNumber;
	private byte[] payload;

	public short getMsgType() {
		return msgType;
	}

	public short getConnId() {
		return connId;
	}

	public short getSeqNumber() {
		return seqNumber;
	}

	public byte[] getPayload() {
		return payload;
	}

	public LspMessage(short msgType, short connId, short seqNumber,
			byte[] payload) {
		this.msgType = msgType;
		this.connId = connId;
		this.seqNumber = seqNumber;
		// if (payload.length > 994)
		// throw new Exception("Payload muito grande.");
		this.payload = payload;
	}

	public LspMessage(byte [] message) {
		ByteBuffer bb = ByteBuffer.wrap(message);
		//System.out.println(message.length + "---" + bb.capacity());
		//System.out.println(new String(message)+"lspmessage");
		this.msgType = bb.getShort();
		this.connId = bb.getShort();
		this.seqNumber = bb.getShort();
//		System.out.println(bb.position());
//		System.out.println(bb.remaining());
		this.payload = new byte[bb.remaining()];
		bb.get(this.payload,0,this.payload.length);
		//System.out.println(new String(this.payload));
		//System.out.println("Fim");
	}
	
	public byte[] getMessage() {
		ByteBuffer bb = ByteBuffer.allocate(6 + this.payload.length);
		bb.putShort(this.msgType);
		bb.putShort(this.connId);
		bb.putShort(this.seqNumber);
		bb.put(this.payload);
		//bb.

		return bb.array();
	}
	
	public int length() {
		return 6 + this.payload.length;
	}
	
	public boolean isConnect(){
		return this.msgType==0;
	}
		

	public boolean isData(){
		return this.msgType==1;
	}
	
	public boolean isAck(){
		return this.msgType==2;
	}
	// public byte
}
