package edu.hit.ir.webcleitapi;

import java.io.IOException;
import java.util.HashMap;

public class LtpService {
//	private String serverAddress = "http://192.168.3.134";
	private String serverAddress = "http://202.118.250.16";
	private String uri = "/ltp";
	private int ports = 12345;
//	private String param;
	private String encoding = "gb2312";
	private String encoding2 = "gb2312";
	private String analysisOptions;
	private boolean isEncoding = false;
	private boolean isAllAnalysis = true;
	private boolean dependencyParser = false;
	private String authorization;
	public LtpService(String authorization) {
		super();
		this.authorization = authorization;
	}
	
	public String Connect(String parameters){
		HashMap<String, String> parMap = new HashMap<String, String>();
		parMap.put("a", authorization);
		if(isEncoding){
			parMap.put("c", encoding);
		}
		if(!isAllAnalysis){
			parMap.put("t", analysisOptions);
		}
		if(dependencyParser){
			parMap.put("x", "y");
		}
		if(parameters!=null){
			parMap.put("s", parameters);
		}
		String str = null;
		try {
			str = WebCleintAPI.doPost(serverAddress + ":" + ports + uri, parMap, encoding2);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return str;
	}
	public boolean setEncoding(String en){
	    if(en == "utf8"){
	        encoding = "utf8";
	        encoding2 = "UTF-8";
	        isEncoding = true;
	    }else if(en == "gb2312"){
	        encoding = "gb2312";
	        encoding2 = "gb2312";
	        isEncoding = false;
	    }else
	        return false;
	    return true;
	}
	public void setAuthorization(String authorization){
		this.authorization = authorization;
	}
	public void setAnalysisOptions(int op){
	    isAllAnalysis = false;
	    switch(op){
	        case 0:
	            analysisOptions = "ws";
	            break;
	        case 1:
	            analysisOptions = "pos";
	            break;
	        case 2:
	            analysisOptions = "ner";
	            break;
	        case 3:
	            analysisOptions = "wsd";
	            break;
	        case 4:
	            analysisOptions = "dp";
	            break;
	        case 5:
	            analysisOptions = "srl";
	            break;
	        default:
	            isAllAnalysis = true;
	    }
	    return;
	}
	public void setAnalysisAll(){
		isAllAnalysis = true;;
	}
	public void setDependencyParser(){
		dependencyParser = true;
	}
}
