package edu.hit.ir.xmlAnalysis;

import java.util.ArrayList;
import java.util.List;

public class DependencyDoc {

	private ArrayList<DependencySent> dc = new ArrayList<DependencySent>();

	public DependencyDoc() {
		super();
	}

	public DependencyDoc(ArrayList<DependencySent> ds) {
		super();
		this.dc = ds;
	}

	public String toString() {
		String formatString = "<?xml version=\"1.0\" encoding=\"gb2312\" ?><xml4nlp><note sent=\"y\" word=\"y\" pos=\"y\" ne=\"n\" parser=\"n\" wsd=\"n\" srl=\"n\"/><doc><para id=\"0\">";
		for(int i = 0; i<dc.size(); ++i){
			formatString += "<sent id=\"" + i + "\" cont=\"" + dc.get(i).getContent() + "\">" + dc.get(i).toString() + "</sent>";
		}
		formatString +="</para></doc></xml4nlp>";
		return formatString;
	}

	public boolean add(DependencySent e) {
		return dc.add(e);
	}

	public void add(int index, DependencySent element) {
		dc.add(index, element);
	}

	public void clear() {
		dc.clear();
	}

	public DependencySent get(int index) {
		return dc.get(index);
	}

	public boolean isEmpty() {
		return dc.isEmpty();
	}

	public DependencySent remove(int index) {
		return dc.remove(index);
	}

	public int size() {
		return dc.size();
	}

	public List<DependencySent> subList(int fromIndex, int toIndex) {
		return dc.subList(fromIndex, toIndex);
	}
	
}
