package edu.hit.ir.xmlAnalysis;

import java.util.ArrayList;
import java.util.List;

public class DependencySent {
	private ArrayList<depUnit> depen = new ArrayList<depUnit>();

	public DependencySent() {
		super();
	}
	
	public String toString(){
		String formatString = "";
//		String sentCont ="";
		for(int i = 0; i<depen.size(); ++i){
			formatString += "<word id=\"" + i 
				+"\" cont=\""+depen.get(i).getCont() + "\" pos=\"" 
				+ depen.get(i).getPos() + "\"/>";
//			sentCont += depen.get(i).getCont();
		}
		/*
		formatString = "<?xml version=\"1.0\" encoding=\"gb2312\" ?><xml4nlp><note sent=\"y\" word=\"y\" pos=\"y\" ne=\"n\" parser=\"n\" wsd=\"n\" srl=\"n\"/><doc><para id=\"0\"><sent id=\"0\" cont=\"" 
			+ sentCont +"\">" + formatString
			+ "</sent></para></doc></xml4nlp>";
			//*/
		return formatString;
	}
	
	public String getContent(){
		String sentCont ="";
		for(int i = 0; i<depen.size(); ++i){
			sentCont += depen.get(i).getCont();
		}
		return sentCont;
	}
	
	public void add(String cont, String pos){
		depen.add(new depUnit(cont, pos));
	}

	public void add(int index, String cont, String pos) {
		depen.add(index, new depUnit(cont, pos));
	}
	
	public boolean add(depUnit e) {
		return depen.add(e);
	}

	public void add(int index, depUnit element) {
		depen.add(index, element);
	}

	public void clear() {
		depen.clear();
	}

	public depUnit get(int index) {
		return depen.get(index);
	}

	public boolean isEmpty() {
		return depen.isEmpty();
	}

	public depUnit remove(int index) {
		return depen.remove(index);
	}

	public depUnit set(int index, depUnit element) {
		return depen.set(index, element);
	}

	public int size() {
		return depen.size();
	}

	public List<depUnit> subList(int fromIndex, int toIndex) {
		return depen.subList(fromIndex, toIndex);
	}
}

class depUnit{
	protected String cont;
	protected String pos;
	
	public depUnit(String cont, String pos) {
		super();
		this.cont = cont;
		this.pos = pos;
	}
	public String getCont() {
		return cont;
	}
	public void setCont(String cont) {
		this.cont = cont;
	}
	public String getPos() {
		return pos;
	}
	public void setPos(String pos) {
		this.pos = pos;
	}
}
