package com;


import com.sun.spot.sensorboard.EDemoBoard;
import com.sun.spot.resources.transducers.ITriColorLED;
import com.sun.spot.resources.transducers.LEDColor;
import com.sun.spot.util.Utils;

/**
 * This is an utility class to have a more simple and fast access to LED resource. 
 * @author Ciccio
 *
 */
public class LedsManager {
	private static ITriColorLED [] leds = EDemoBoard.getInstance().getLEDs();
	
	/**
	 * set OFF a LED
	 * @param index LED's index
	 */
	public static void ledOFF(int index){
		leds[index].setOff();
	}
	
	/**
	 * set ON a LED
	 * @param index LED's index
	 * @param ld LED's color
	 */
	public static void ledON(int index, LEDColor ld){
		leds[index].setOff();
		leds[index].setColor(ld);
		leds[index].setOn();
	}
	
	/**
	 * set ON the 7th LED. The color is RED 
	 */
	public static void error() {
		leds[7].setOff();
		leds[7].setColor(LEDColor.RED);
		leds[7].setOn();
	}
	
	/**
	 * set ON the 7th LED. It's possible to choose the color
	 * @param lc
	 */
	public static void error(LEDColor lc) {
		leds[7].setOff();
		leds[7].setColor(lc);
		leds[7].setOn();
	}
	
	/**
	 * blink the 6th LED for radio transmission. It uses 4 colors: datagram or datastream, receiving or sending
	 * @param datagram true if it's a datagram connection, false if it's datastream 
	 * @param receiving true if it's a receiving connection, false otherwise
	 */
	public static void radioTransmission(boolean datagram, boolean receiving) {
		
		LEDColor color = null;
		
		if (datagram && receiving)
			color = LEDColor.GREEN;
		else if (datagram && !receiving)
			color = LEDColor.WHITE;
		else if (!datagram && receiving)
			color = LEDColor.MAGENTA;
		else if (!datagram && !receiving)
			color = LEDColor.YELLOW;
		
		for (int i = 0; i < 3; i++) {
			leds[6].setColor(color);		
			leds[6].setOn();
			Utils.sleep(100);
			radioStandby();
			Utils.sleep(50);
		}
	}

	/**
	 * blink one of the LED with the selected color
	 * @param index LED's index
	 * @param color LED's color
	 */
	public static void blink(int index, LEDColor color) {
		
		if (leds[index].isOn()) {
			LEDColor oldColor = leds[index].getColor();
			leds[index].setOff();
			leds[index].setColor(color);
			leds[index].setOn();
			Utils.sleep(500);
			leds[index].setOff();
			leds[index].setColor(oldColor);
			leds[index].setOn();
		}
		else {
			ledON(index, color);
			Utils.sleep(500);
			ledOFF(index);
		}
	}
	
	/**
	 * Set ON the 6th LED with blue color. It means that node is ready to receive data  
	 */
	public static void radioStandby() {
		
		leds[6].setColor(LEDColor.BLUE);
		leds[6].setOn();		
	}
}
