package requestEnvelopes.agent;

import agent.Agent;

import com.Event;
import com.sun.spot.interisolate.ObjectReplyEnvelope;
import com.sun.spot.interisolate.ReplyEnvelope;
import com.sun.spot.interisolate.RequestEnvelope;

/**
 * This class allows the Execution Engine to send events to own agents.
 * It takes advantage of "InterIsolateServer" communication offered by SunSPOT SDK 
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public class ReceiveEvent extends RequestEnvelope{

	private Event event;
	
	public ReceiveEvent (Event event){
		this.event = event;
	}
	
	public ReplyEnvelope execute(Object context){
		((Agent)context).receiveEvent(event);
		return new ObjectReplyEnvelope(getUid(), null);
	}

}
