package requestEnvelopes.server;

import java.util.Vector;

import server.interfaces.IMobileAgentExecutionEngine;

import com.sun.spot.interisolate.ObjectReplyEnvelope;
import com.sun.spot.interisolate.ReplyEnvelope;
import com.sun.spot.interisolate.RequestEnvelope;

/**
 * This class allows the Agent to invoke Execution Engine's getLocalAgentsID method.
 * It takes advantage of "InterIsolateServer" communication offered by SunSPOT SDK 
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public class GetLocalAgentsID extends RequestEnvelope{
	
	public ReplyEnvelope execute(Object context){
		Vector localAgents = ((IMobileAgentExecutionEngine)context).getLocalAgentsID();
		return new ObjectReplyEnvelope(getUid(), localAgents);
	}

}
