package requestEnvelopes.server;

import com.sun.spot.interisolate.ObjectReplyEnvelope;
import com.sun.spot.interisolate.ReplyEnvelope;
import com.sun.spot.interisolate.RequestEnvelope;
import com.sun.spot.util.IEEEAddress;

import server.interfaces.IMobileAgentExecutionEngine;

/**
 * This class allows the Agent to invoke Execution Engine's getMyIEEEAddress method.
 * It takes advantage of "InterIsolateServer" communication offered by SunSPOT SDK 
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public class GetMyIEEEAddress extends RequestEnvelope{
	
	public ReplyEnvelope execute(Object context){
		IEEEAddress myAddress = ((IMobileAgentExecutionEngine)context).getMyIEEEAddress();
		return new ObjectReplyEnvelope(getUid(), myAddress);
	}

}
