package requestEnvelopes.server;

import java.util.Vector;

import server.interfaces.IMobileAgentExecutionEngine;

import com.sun.spot.interisolate.ObjectReplyEnvelope;
import com.sun.spot.interisolate.ReplyEnvelope;
import com.sun.spot.interisolate.RequestEnvelope;

/**
 * This class allows the Agent to invoke Execution Engine's getRemoteAgentsID method.
 * It takes advantage of "InterIsolateServer" communication offered by SunSPOT SDK 
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public class GetRemoteAgentsID extends RequestEnvelope{
	
	public ReplyEnvelope execute(Object context){
		Vector remoteAgents= ((IMobileAgentExecutionEngine)context).getRemoteAgentsID();
		return new ObjectReplyEnvelope(getUid(), remoteAgents);
	}

}
