package requestEnvelopes.server;

import com.sun.spot.interisolate.ReplyEnvelope;
import com.sun.spot.interisolate.RequestEnvelope;
import com.sun.spot.interisolate.VoidReplyEnvelope;

import server.interfaces.IMobileAgentExecutionEngine;

/**
 * This class allows the Agent to invoke Execution Engine's migrate method.
 * It takes advantage of "InterIsolateServer" communication offered by SunSPOT SDK 
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public class Migrate extends RequestEnvelope{

	private String sourceID;
	private String nodeIDDest;
	
	public Migrate (String sourceID, String nodeIDDest){
		this.sourceID = sourceID;
		this.nodeIDDest = nodeIDDest;
	}
	
	public ReplyEnvelope execute(Object context){
		((IMobileAgentExecutionEngine)context).migrate(sourceID, nodeIDDest);
		return new VoidReplyEnvelope(getUid());
	}

}
