package requestEnvelopes.server;

import com.sun.spot.interisolate.ReplyEnvelope;
import com.sun.spot.interisolate.RequestEnvelope;
import com.sun.spot.interisolate.VoidReplyEnvelope;

import server.interfaces.IMobileAgentExecutionEngine;

/**
 * This class allows the Agent to invoke Execution Engine's resetTimer method.
 * It takes advantage of "InterIsolateServer" communication offered by SunSPOT SDK 
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public class ResetTimer extends RequestEnvelope{

	private String sourceMA;
	private String timerID;
	
	public ResetTimer (String sourceMA, String timerID){
		this.sourceMA = sourceMA;
		this.timerID = timerID;
	}
	
	public ReplyEnvelope execute(Object context){
		((IMobileAgentExecutionEngine)context).resetTimer(sourceMA, timerID);
		return new VoidReplyEnvelope(getUid());
	}

}