package requestEnvelopes.server;

import com.Event;
import com.sun.spot.interisolate.ObjectReplyEnvelope;
import com.sun.spot.interisolate.ReplyEnvelope;
import com.sun.spot.interisolate.RequestEnvelope;

import server.interfaces.IMobileAgentExecutionEngine;

/**
 * This class allows the Agent to invoke Execution Engine's setTimer method.
 * It takes advantage of "InterIsolateServer" communication offered by SunSPOT SDK 
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public class SetTimer extends RequestEnvelope{

	private String sourceMA;
	private boolean periodic;
	private long timeout;
	private Event backEvent;
	
	public SetTimer (String sourceMA, boolean periodic,
			long timeout, Event backEvent){
		this.sourceMA = sourceMA;
		this.periodic = periodic;
		this.timeout = timeout;
		this.backEvent = backEvent;
	}
	
	public ReplyEnvelope execute(Object context){
		String timerID = ((IMobileAgentExecutionEngine)context).setTimer(sourceMA, periodic, timeout, backEvent);
		return new ObjectReplyEnvelope(getUid(), timerID);
	}

}
