package requestEnvelopes.server;

import com.sun.spot.interisolate.ReplyEnvelope;
import com.sun.spot.interisolate.RequestEnvelope;
import com.sun.spot.interisolate.VoidReplyEnvelope;

import server.interfaces.IMobileAgentExecutionEngine;

/**
 * This class allows the Agent to invoke Execution Engine's terminateAgent method.
 * It takes advantage of "InterIsolateServer" communication offered by SunSPOT SDK 
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public class TerminateAgent extends RequestEnvelope{

	private String agentName;
	
	public TerminateAgent (String agentName){
		this.agentName = agentName;
	}
	
	public ReplyEnvelope execute(Object context){
		((IMobileAgentExecutionEngine)context).terminateAgent(agentName);
		return new VoidReplyEnvelope(getUid());
	}

}
