package sensorBoard;

import com.Event;

/**
 * This interface is implemented by a class that handle the events for a specific resource 
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public interface ISensorBoardComponent {
	
	/**
	 * It handles the event
	 * @param event event to handle
	 */
	public void handleEvent (Event event);
	
	/**
	 * Check if the class can handle the event
	 * @param eventName name of the event to handle
	 * @return true if the event is "handlable", false otherwise 
	 */
	public boolean IsEventHandlable (byte eventName);
	
	/**
	 * This method is invoked to send the backEvent to own ISensorBoardManager
	 * @param backEvent the event to send
	 */
	public void send(Event backEvent);
	
	/**
	 * This method is invoked to terminate the execution of a ISensorBoardComponentListener 
	 * @param sensorID ISensorBoardComponentListener's ID
	 * @return true if it's terminated, false otherwise
	 */
	public boolean terminateListener(String sensorID);
	
}
