package sensorBoard;

/**
 * This interface is implemented by a class that listen the value changes of a particular sensor board component
 * and send the backEvent to the agent 
 * @author Francesco Aiello, Antonio Guerrieri, Raffaele Gravina
 *
 */
public interface ISensorBoardComponentListener {
	
	/**
	 * Terminates the listener execution
	 * @return true if the listener is terminated, false otherwise
	 */
	public boolean terminateListener ();
	
	/**
	 * Getter of the property <tt>sensorBoardComponentID</tt>
	 * @return the sensorBoardComponentID.
	 */
	public String getSensorBoardComponentID();
}
